<?php 
require_once 'includes/header.php'; 

// --- PAGE-SPECIFIC QUERIES ---
$tour_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$tour_id) {
    // You can create a proper 404 page later
    echo "<div class='container my-5'><div class='alert alert-danger'>Invalid Tour ID.</div></div>";
    require_once 'includes/footer.php';
    exit();
}

// 1. Fetch main tour details and partner info
$stmt = $conn->prepare("
    SELECT t.*, p.full_name AS partner_name, p.profile_image_url AS partner_image, p.is_verified AS partner_is_verified
    FROM tours t
    LEFT JOIN users p ON t.partner_id = p.id AND p.role LIKE '%partner%'
    WHERE t.id = ? AND t.status = 'published'
");
$stmt->bind_param("i", $tour_id);
$stmt->execute();
$tour = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$tour) {
    echo "<div class='container my-5'><div class='alert alert-warning'>Sorry, this tour was not found.</div></div>";
    require_once 'includes/footer.php';
    exit();
}

$page_title = htmlspecialchars($tour['title']);

// 2. Fetch gallery images for this tour
$stmt_gallery = $conn->prepare("SELECT image_url FROM galleries WHERE item_id = ? AND item_type = 'tour' ORDER BY display_order ASC");
$stmt_gallery->bind_param("i", $tour_id);
$stmt_gallery->execute();
$gallery_images = $stmt_gallery->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_gallery->close();

// 3. Fetch recent reviews for this tour
$stmt_reviews = $conn->prepare("SELECT ur.rating, ur.review_text, u.full_name FROM user_reviews ur JOIN users u ON ur.user_id = u.id WHERE ur.item_id = ? AND ur.item_type = 'tour' AND ur.is_approved = 1 ORDER BY ur.created_at DESC LIMIT 3");
$stmt_reviews->bind_param("i", $tour_id);
$stmt_reviews->execute();
$reviews = $stmt_reviews->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_reviews->close();
?>

<div class="container my-5">
    <div class="row">
        <div class="col-lg-8">
            <h1 class="display-5 fw-bold"><?php echo htmlspecialchars($tour['title']); ?></h1>
            <p class="lead text-muted mb-4"><i class="bi bi-geo-alt-fill me-1"></i><?php echo htmlspecialchars($tour['location']); ?></p>

            <div class="mb-4">
                <img src="<?php echo htmlspecialchars($tour['image_url']); ?>" class="img-fluid rounded shadow-sm w-100" alt="Main image of <?php echo htmlspecialchars($tour['title']); ?>">
            </div>

            <div class="card shadow-sm border-0 mb-4">
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col"><i class="bi bi-clock-history fs-4 text-primary"></i><div class="fw-bold mt-1"><?php echo htmlspecialchars($tour['duration_days']); ?> Day(s)</div></div>
                        <div class="col"><i class="bi bi-people-fill fs-4 text-primary"></i><div class="fw-bold mt-1">Group Tour</div></div>
                        <div class="col"><i class="bi bi-translate fs-4 text-primary"></i><div class="fw-bold mt-1">English</div></div>
                    </div>
                </div>
            </div>

            <h4 class="fw-bold">About this tour</h4>
            <div class="text-secondary">
                <?php echo $tour['description']; // Directly echo to render HTML from editor ?>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow-sm border-0 sticky-top" style="top: 100px;">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span class="fs-2 fw-bold text-primary"><?php echo format_price($tour['price']); ?></span>
                        <span class="text-muted">per person</span>
                    </div>
                    <div class="d-grid">
                        <a href="booking.php?tour_id=<?php echo $tour['id']; ?>" class="btn btn-primary btn-lg">Book Now</a>
                    </div>
                </div>
                <?php if (!empty($tour['partner_name'])): ?>
                <div class="card-footer bg-light text-center">
                    <p class="mb-1 small text-muted">Offered by:</p>
                    <strong class="d-block"><?php echo htmlspecialchars($tour['partner_name']); ?></strong>
                    <?php 
                        // The new function is called here
                        display_verified_badge($tour['partner_is_verified']); 
                    ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <hr class="my-5">
    <div class="row">
        <div class="col-12">
            <h3 class="fw-bold mb-4">Recent Reviews</h3>
            <?php if (empty($reviews)): ?>
                <p class="text-muted">There are no reviews for this tour yet.</p>
            <?php else: ?>
                <?php foreach ($reviews as $review): ?>
                <div class="card mb-3 border-0 shadow-sm">
                    <div class="card-body">
                        <div class="d-flex">
                            <div class="flex-shrink-0"><i class="bi bi-person-circle fs-2 text-muted"></i></div>
                            <div class="flex-grow-1 ms-3">
                                <strong><?php echo htmlspecialchars($review['full_name']); ?></strong>
                                <div class="text-warning mb-1"><?php for($i=0; $i<$review['rating']; $i++) echo '<i class="bi bi-star-fill"></i>'; ?></div>
                                <p><?php echo htmlspecialchars($review['review_text']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php 
require_once 'includes/footer.php'; 
?>
