<?php if (!isset($booking) || !isset($site_settings)) { die('Required data is missing.'); } ?>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>
        @page { margin: 0; }
        body { font-family: 'DejaVu Sans', sans-serif; font-size: 12px; color: #333; margin: 0; }
        .ticket { width: 100%; max-width: 800px; min-height: 350px; margin: 20px auto; border: 1px solid #ddd; display: table; table-layout: fixed; box-shadow: 0 0 10px rgba(0,0,0,0.1); border-radius: 10px; overflow: hidden; }
        .main { width: 70%; display: table-cell; padding: 25px; vertical-align: top; }
        .stub { width: 30%; display: table-cell; vertical-align: top; border-left: 2px dashed #ccc; text-align: center; padding: 25px; background-color: #f9f9f9; }
        .header { background-color: <?php echo htmlspecialchars($site_settings['ticket_header_color'] ?? '#0d6efd'); ?>; color: white; padding: 15px 25px; text-align: left; margin: -25px -25px 20px -25px; display: table; width: 100%;}
        .header img { max-height: 40px; display: table-cell; vertical-align: middle; }
        .header h2 { display: table-cell; vertical-align: middle; font-size: 18px; padding-left: 15px; text-transform: uppercase; }
        .info-block { margin-bottom: 20px; }
        .info-block h4 { color: <?php echo htmlspecialchars($site_settings['ticket_accent_color'] ?? '#888'); ?>; font-size: 11px; margin-bottom: 2px; text-transform: uppercase; letter-spacing: 0.5px; }
        .info-block p { font-size: 16px; font-weight: bold; margin: 0; }
        .notes { font-size: 10px; color: #777; line-height: 1.5; }
    </style>
</head>
<body>
    <div class="ticket">
        <div class="main">
            <div class="header">
                <?php $logo_to_use = is_color_dark($site_settings['ticket_header_color']) ? $site_settings['site_logo_light_url'] : $site_settings['site_logo_url']; if (!empty($logo_to_use)): ?><img src="<?php echo $_SERVER['DOCUMENT_ROOT'] . '/' . strtok($logo_to_use, '?'); ?>"><?php endif; ?>
                <h2>Ferry Voucher</h2>
            </div>
            <table style="width:100%; margin-bottom: 15px;"><tr>
                <td style="width:50%; vertical-align: top;"><h4>DEPARTING FROM</h4><p><?php echo htmlspecialchars($booking['origin_city']); ?></p></td>
                <td style="width:50%; vertical-align: top;"><h4>ARRIVING AT</h4><p><?php echo htmlspecialchars($booking['dest_city']); ?></p></td>
            </tr></table>
            <div class="info-block"><h4>PASSENGER</h4><p><?php echo htmlspecialchars($booking['full_name']); ?></p></div>
            <table style="width:100%; margin-bottom: 20px;"><tr>
                <td style="width:50%; vertical-align: top;"><h4>DEPARTURE DATE</h4><p><?php echo date("F j, Y", strtotime($booking['departure_date'])); ?></p></td>
                <td style="width:50%; vertical-align: top;"><h4>PASSENGERS</h4><p><?php echo $booking['num_passengers']; ?></p></td>
            </tr></table>
            <h4>IMPORTANT NOTES</h4>
            <p class="notes"><?php echo nl2br(htmlspecialchars($site_settings['ticket_notes_ferry'] ?? '')); ?></p>
        </div>
        <div class="stub">
            <p style="font-size: 12px; margin-bottom: 15px;"><?php echo htmlspecialchars($booking['origin_city'] . ' → ' . $booking['dest_city']); ?></p>
            <h4>PASSENGER</h4><p style="font-size: 12px; margin-bottom: 15px;"><?php echo htmlspecialchars($booking['full_name']); ?></p>
            <h4>BOOKING REFERENCE</h4>
<p style="font-size: 14px; ..."><?php echo htmlspecialchars($booking['booking_ref']); ?></p>
            <img src="<?php echo $qr_code_path; ?>" style="width: 110px; height: 110px;">
            <p class="notes" style="margin-top: 10px;">Scan to verify</p>
            <p style="margin-top: 20px;"><strong style="color: green;">PAID IN FULL</strong><br><?php echo display_price($booking['total_price'], $current_currency, $rates, $site_settings['site_base_currency']); ?></p>
        </div>
    </div>
</body>
</html>
