self.addEventListener('push', function (event) {
    if (!event.data) {
        console.log('Push event but no data');
        return;
    }
    const data = event.data.json();
    const title = data.title || 'New Booking Notification';
    const options = {
        body: data.body,
        icon: data.icon || '/uploads/site/logo.png', // A default icon
        badge: data.badge || '/uploads/site/logo.png', // For mobile
        data: {
            url: data.url
        }
    };
    event.waitUntil(self.registration.showNotification(title, options));
});

self.addEventListener('notificationclick', function (event) {
    event.notification.close();
    if (event.notification.data && event.notification.data.url) {
        event.waitUntil(clients.openWindow(event.notification.data.url));
    }
});
