<?php 
// 1. INCLUDE HEADER & HELPERS
include 'includes/header.php'; 
require_once 'includes/helpers.php'; 

// 2. PAGINATION & DATA FETCHING
$records_per_page = 9;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $records_per_page;
$keyword = trim($_GET['keyword'] ?? '');

// Base WHERE clause to ensure we only get Services
$where_clauses = ["category = 'Service'", "status = 'published'"];
$params = [];
$types = '';

if (!empty($keyword)) {
    $where_clauses[] = "(title LIKE ? OR location LIKE ?)";
    $like_term = "%{$keyword}%";
    array_push($params, $like_term, $like_term);
    $types .= 'ss';
}

$where_sql = "WHERE " . implode(' AND ', $where_clauses);

// Count total results for pagination
$count_sql = "SELECT COUNT(id) as total FROM tours $where_sql";
$stmt_count = $conn->prepare($count_sql);
if (!empty($params)) { $stmt_count->bind_param($types, ...$params); }
$stmt_count->execute();
$total_records = $stmt_count->get_result()->fetch_assoc()['total'];
$total_pages = ceil($total_records / $records_per_page);
$stmt_count->close();

// Fetch the services for the current page
$fetch_sql = "SELECT * FROM tours $where_sql ORDER BY is_featured DESC, title ASC LIMIT ? OFFSET ?";
$params[] = $records_per_page; $params[] = $offset; $types .= 'ii';
$stmt_fetch = $conn->prepare($fetch_sql);
if (count($params) > 2) { $stmt_fetch->bind_param($types, ...$params); } 
else { $stmt_fetch->bind_param("ii", $records_per_page, $offset); }
$stmt_fetch->execute();
$results = $stmt_fetch->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_fetch->close();
?>

<div class="container my-4">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Services</li>
        </ol>
    </nav>
    <h1 class="display-5">Service Search Results</h1>
    <?php if (!empty($keyword)): ?>
        <p class="lead text-muted">Showing results for: "<?php echo htmlspecialchars($keyword); ?>"</p>
    <?php endif; ?>
</div>

<div class="container mb-5">
    <?php if (!empty($results)): ?>
    <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-4">
        <?php foreach ($results as $item): ?>
        <div class="col">
            <div class="card h-100 tour-card shadow-sm">
                <a href="service-details.php?id=<?php echo $item['id']; ?>">
                    <img src="<?php echo htmlspecialchars($item['image_url']); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($item['title']); ?>">
                </a>
                <div class="card-body d-flex flex-column">
                    <h5 class="card-title"><?php echo htmlspecialchars($item['title']); ?></h5>
                    <p class="card-text text-muted small"><i class="bi bi-geo-alt-fill"></i> <?php echo htmlspecialchars($item['location']); ?></p>
                    <div class="mt-auto">
                        <p class="mb-2">From <span class="fw-bold h5">₱<?php echo number_format($item['price'], 2); ?></span></p>
                        <a href="service-details.php?id=<?php echo $item['id']; ?>" class="btn btn-primary w-100">View Details</a>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php else: ?>
        <div class="text-center p-5 border rounded"><h3 class="text-muted">No Services Found</h3><p>Sorry, no services matched your search criteria. Please try a different keyword.</p></div>
    <?php endif; ?>
    
    <?php if($total_pages > 1): ?>
    <nav class="mt-5"><ul class="pagination justify-content-center">
        <?php $query_params = $_GET; for ($i = 1; $i <= $total_pages; $i++): $query_params['page'] = $i; ?>
            <li class="page-item <?php echo ($i == $page) ? 'active' : ''; ?>"><a class="page-link" href="?<?php echo http_build_query($query_params); ?>"><?php echo $i; ?></a></li>
        <?php endfor; ?>
    </ul></nav>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>
