<?php
session_start();
require_once '../includes/db.php';
require_once '../includes/helpers.php';

if (!isset($_SESSION['partner_logged_in']) || !isset($_SESSION['partner_id'])) {
    header('Location: login.php');
    exit;
}
$partner_id = $_SESSION['partner_id'];

// Fetch tours belonging ONLY to the logged-in partner
$stmt = $pdo->prepare("SELECT id, title, location, price, status FROM tours WHERE partner_id = ? ORDER BY created_at DESC");
$stmt->execute([$partner_id]);
$tours = $stmt->fetchAll();

$page_title = "My Tours & Services";
$current_page = 'manage-tours.php';
include 'header.php'; // Assuming partner header
?>
<div class="container mt-4">
    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2"><?php echo $page_title; ?></h1>
        <a href="edit-tour.php" class="btn btn-primary">Add New Tour/Service</a>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Location</th>
                            <th>Price</th>
                            <th>Status</th>
                            <th class="text-end">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($tours as $tour): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($tour['title']); ?></td>
                            <td><?php echo htmlspecialchars($tour['location']); ?></td>
                            <td>$<?php echo number_format($tour['price'], 2); ?></td>
                            <td><span class="badge bg-<?php echo $tour['status'] === 'published' ? 'success' : 'secondary'; ?>"><?php echo htmlspecialchars(ucfirst($tour['status'])); ?></span></td>
                            <td class="text-end">
                                <a href="manage-tour-availability.php?tour_id=<?php echo $tour['id']; ?>" class="btn btn-sm btn-info" title="Manage Availability">
                                    <i class="bi bi-calendar-check-fill"></i> Availability
                                </a>
                                <a href="edit-tour.php?id=<?php echo $tour['id']; ?>" class="btn btn-sm btn-outline-primary" title="Edit">
                                    <i class="bi bi-pencil-fill"></i>
                                </a>
                                <a href="delete-tour.php?id=<?php echo $tour['id']; ?>" class="btn btn-sm btn-outline-danger" title="Delete" onclick="return confirm('Are you sure?');">
                                    <i class="bi bi-trash-fill"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include 'footer.php'; // Assuming partner footer ?>
