<?php
require_once 'header.php'; 
$tour_id = filter_input(INPUT_GET, 'tour_id', FILTER_VALIDATE_INT);
if (!$tour_id) { die("Invalid Tour ID."); }

$stmt = $conn->prepare("SELECT title FROM tours WHERE id = ? AND partner_id = ?");
$stmt->bind_param("ii", $tour_id, $partner_id);
$stmt->execute();
$tour = $stmt->get_result()->fetch_assoc();
$stmt->close();
if (!$tour) { die("Error: Tour not found or you do not have permission to manage it."); }

$page_title = 'Availability: ' . htmlspecialchars($tour['title']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    if ($action === 'add_availability') {
        $date = $_POST['available_date'];
        $slots = filter_input(INPUT_POST, 'slots_available', FILTER_VALIDATE_INT);
        if ($date && $slots > 0) {
            $stmt_add = $conn->prepare("INSERT INTO tour_availability (tour_id, available_date, slots_available) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE slots_available = ?");
            $stmt_add->bind_param("isis", $tour_id, $date, $slots, $slots);
            $stmt_add->execute();
            $stmt_add->close();
        }
    } elseif ($action === 'delete_availability') {
        $avail_id = filter_input(INPUT_POST, 'availability_id', FILTER_VALIDATE_INT);
        $stmt_del = $conn->prepare("DELETE FROM tour_availability WHERE id = ? AND tour_id = ?");
        $stmt_del->bind_param("ii", $avail_id, $tour_id);
        $stmt_del->execute();
        $stmt_del->close();
    }
    header("Location: manage-tour-availability.php?tour_id=" . $tour_id);
    exit();
}

$stmt_avail = $conn->prepare("SELECT * FROM tour_availability WHERE tour_id = ? ORDER BY available_date ASC");
$stmt_avail->bind_param("i", $tour_id);
$stmt_avail->execute();
$availabilities = $stmt_avail->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt_avail->close();
?>
<div class="d-flex justify-content-between align-items-center pt-3 pb-2 mb-3 border-bottom">
    <div><h1 class="h2">Manage Availability</h1><p class="text-muted"><?php echo htmlspecialchars($tour['title']); ?></p></div>
    <a href="manage-listings.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back to Listings</a>
</div>
<div class="row">
    <div class="col-lg-4 mb-4">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light border-0"><h5 class="mb-0">Add / Update Date</h5></div>
            <div class="card-body">
                <form method="POST">
                    <input type="hidden" name="action" value="add_availability">
                    <div class="mb-3"><label for="available_date" class="form-label">Date</label><input type="date" class="form-control" id="available_date" name="available_date" required></div>
                    <div class="mb-3"><label for="slots_available" class="form-label">Available Slots</label><input type="number" class="form-control" id="slots_available" name="slots_available" min="1" required></div>
                    <button type="submit" class="btn btn-primary">Save</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light border-0"><h5 class="mb-0">Current Availability</h5></div>
            <div class="card-body">
                <div class="table-responsive"><table class="table table-hover">
                    <thead><tr><th>Date</th><th>Slots</th><th class="text-end">Actions</th></tr></thead>
                    <tbody>
                    <?php if (empty($availabilities)): ?>
                        <tr><td colspan="3" class="text-center text-muted">No dates have been set.</td></tr>
                    <?php else: ?>
                        <?php foreach ($availabilities as $avail): ?>
                        <tr>
                            <td><?php echo date('F j, Y', strtotime($avail['available_date'])); ?></td>
                            <td><?php echo $avail['slots_available']; ?></td>
                            <td class="text-end"><form method="POST" onsubmit="return confirm('Are you sure?');" class="d-inline"><input type="hidden" name="action" value="delete_availability"><input type="hidden" name="availability_id" value="<?php echo $avail['id']; ?>"><button type="submit" class="btn btn-sm btn-outline-danger"><i class="bi bi-trash-fill"></i></button></form></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                    </tbody>
                </table></div>
            </div>
        </div>
    </div>
</div>
<?php require_once 'footer.php'; ?>
