<?php 
include 'includes/header.php'; 
$slug = trim($_GET['slug'] ?? '');
if (empty($slug)) { header("Location: index.php"); exit(); }

// UPDATED QUERY: Now checks for is_verified = 1
$stmt = $conn->prepare("SELECT * FROM users WHERE profile_slug = ? AND status = 'active' AND profile_page_status = 'Active' AND is_verified = 1");
$stmt->bind_param("s", $slug);
$stmt->execute();
$partner = $stmt->get_result()->fetch_assoc();

if (!$partner) { 
    include 'includes/footer.php'; 
    exit("<div class='container my-5 alert alert-warning text-center'>This partner profile is currently unavailable.</div>"); 
}

// Fetch this partner's listings
$listings_result = null;
if ($partner['role'] == 'tour_partner') {
    $stmt_listings = $conn->prepare("SELECT id, title, image_url, location, price, 'tour' as type FROM tours WHERE partner_id = ?");
} elseif ($partner['role'] == 'hotel_partner') {
    $stmt_listings = $conn->prepare("SELECT id, name as title, main_image_url as image_url, location, 0 as price, 'hotel' as type FROM hotels WHERE partner_id = ?");
}
if(isset($stmt_listings)){
    $stmt_listings->bind_param("i", $partner['id']);
    $stmt_listings->execute();
    $listings_result = $stmt_listings->get_result();
}
?>
<main class="container my-5">
    <div class="card shadow-sm p-4 text-center mb-5" style="border-top: 5px solid var(--primary-color);">
        <?php if (!empty($partner['profile_image_url'])): ?><img src="/<?php echo htmlspecialchars($partner['profile_image_url']); ?>" class="rounded-circle mx-auto" style="width: 120px; height: 120px; object-fit: cover; margin-top: -80px; border: 4px solid white; background: white;"><?php endif; ?>
        <h1 class="mt-3"><?php echo htmlspecialchars($partner['full_name']); ?></h1>
        <?php if ($partner['is_verified']): ?><p><span class="verified-badge fs-6"><i class="bi bi-patch-check-fill"></i> Verified Partner</span></p><?php endif; ?>
        <p class="text-muted col-lg-8 mx-auto"><?php echo nl2br(htmlspecialchars($partner['bio'])); ?></p>
    </div>
    <h2>Our Listings</h2><hr>
    <div class="row">
    <?php if($listings_result && $listings_result->num_rows > 0): while($listing = $listings_result->fetch_assoc()): ?>
        <div class="col-md-4 mb-4">
            <div class="card h-100 tour-card">
                <?php $details_page = ($listing['type'] == 'tour') ? 'service-details.php' : 'hotel-details.php'; ?>
                <a href="/<?php echo $details_page; ?>?id=<?php echo $listing['id']; ?>"><img src="/<?php echo htmlspecialchars($listing['image_url']); ?>" class="card-img-top"></a>
                <div class="card-body d-flex flex-column">
                    <h5 class="card-title"><?php echo htmlspecialchars($listing['title']); ?></h5>
                    <p class="card-text text-muted"><i class="bi bi-geo-alt-fill"></i> <?php echo htmlspecialchars($listing['location']); ?></p>
                    <a href="/<?php echo $details_page; ?>?id=<?php echo $listing['id']; ?>" class="btn btn-primary mt-auto">View Details</a>
                </div>
            </div>
        </div>
    <?php endwhile; else: ?><p>This partner has no active listings yet.</p><?php endif; ?>
    </div>
</main>
<?php include 'includes/footer.php'; ?>
