<?php
    /*
     * PHP QR Code encoder
     *
     * Config file, feel free to edit
     */
     
    define('QR_CACHEABLE', true);                        // use cache - more disk reads but less CPU power, masks and format templates are stored there
    define('QR_CACHE_DIR', dirname(__FILE__).'/cache/'); // used when QR_CACHEABLE === true
    define('QR_LOG_DIR', dirname(__FILE__).'/');
    
    define('QR_FIND_BEST_MASK', true);                                                          // if true, estimates best mask (spec. default, but extremally slow; set to false to significant performance boost but (propably) worst quality code
    define('QR_FIND_FROM_RANDOM', false);                                                       // if false, checks all masks for each generated matrix
    define('QR_DEFAULT_MASK', 2);                                                               // when QR_FIND_BEST_MASK === false
    
    define('QR_PNG_MAXIMUM_SIZE',  1024);                                                        // maximum allowed png image width (in pixels), tune to make sure GD and PHP can handle such big images

    // Tools
    include "qrconst.php";
    include "qrtools.php";
    include "qrspec.php";
    include "qrimage.php";
    include "qrinput.php";
    include "qrencode.php";
    include "qrsplit.php";
    
    class QRcode {
        
        public $version;
        public $width;
        public $data;
        
        //----------------------------------------------------------------------
        public static function png($text, $outfile = false, $level = QR_ECLEVEL_L, $size = 3, $margin = 4, $saveandprint=false) 
        {
            $enc = QRencode::factory($level, $size, $margin);
            return $enc->encodePNG($text, $outfile, $saveandprint=false);
        }
        
        //----------------------------------------------------------------------
        public static function text($text, $outfile = false, $level = QR_ECLEVEL_L, $size = 3, $margin = 4) 
        {
            $enc = QRencode::factory($level, $size, $margin);
            return $enc->encode($text, $outfile);
        }
        
        //----------------------------------------------------------------------
        public static function raw($text, $outfile = false, $level = QR_ECLEVEL_L, $size = 3, $margin = 4) 
        {
            $enc = QRencode::factory($level, $size, $margin);
            return $enc->encode($text, $outfile);
        }
    }
