<?php
// ferry-details.php
$route_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($route_id <= 0) { header("Location: ferries.php"); exit(); }

$page_title = "Ferry Details";
include 'includes/header.php';

// Fetch Route Details with Port Names
$stmt = $conn->prepare("SELECT fr.*, orig.name as origin_name, dest.name as destination_name
                        FROM ferry_routes fr
                        JOIN ferry_ports orig ON fr.origin_port_id = orig.id
                        JOIN ferry_ports dest ON fr.destination_port_id = dest.id
                        WHERE fr.id = ? AND fr.is_published = 1");
$stmt->bind_param("i", $route_id);
$stmt->execute();
$route = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$route) {
    echo '<div class="container my-5"><div class="alert alert-danger text-center"><h2>Route Not Found</h2><p>This ferry route is not available.</p><a href="ferries.php" class="btn btn-primary">Back to All Routes</a></div></div>';
    include 'includes/footer.php';
    exit();
}
$page_title = htmlspecialchars($route['origin_name']) . " to " . htmlspecialchars($route['destination_name']);
?>
<style>
    .booking-widget { position: sticky; top: 100px; }
    .info-bar .info-item {
        border-right: 1px solid var(--bs-border-color);
    }
    .info-bar .info-item:last-child {
        border-right: none;
    }
</style>

<div class="container my-5">
    <div class="row g-5">
        <div class="col-lg-8">
            <div class="mb-4">
                <p class="text-muted">Operated by <strong><?php echo htmlspecialchars($route['ferry_company']); ?></strong></p>
                <h1 class="display-5 fw-bold"><?php echo htmlspecialchars($route['origin_name']); ?> <i class="bi bi-arrow-right-short"></i> <?php echo htmlspecialchars($route['destination_name']); ?></h1>
            </div>
            <img src="/<?php echo htmlspecialchars($route['main_image_url'] ?? 'assets/images/default-ferry.jpg'); ?>" class="img-fluid rounded shadow-sm mb-4" alt="Ferry">
            
            <div class="card shadow-sm mb-4">
                <div class="card-body p-4 row text-center info-bar">
                    <div class="col-md-4 info-item"><i class="bi bi-cash-coin fs-2 text-primary"></i><div><strong>Price</strong><br>₱<?php echo number_format($route['price']); ?></div></div>
                    <div class="col-md-4 info-item"><i class="bi bi-clock fs-2 text-primary"></i><div><strong>Duration</strong><br><?php echo $route['duration_hours']; ?> hours</div></div>
                    <div class="col-md-4 info-item"><i class="bi bi-door-open-fill fs-2 text-primary"></i><div><strong>Class</strong><br>Economy</div></div>
                </div>
            </div>
            
            <div class="tour-details">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item" role="presentation"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#overview" type="button">Overview</button></li>
                    <li class="nav-item" role="presentation"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#schedule" type="button">Schedule</button></li>
                </ul>
                <div class="tab-content pt-4">
                    <div class="tab-pane fade show active" id="overview" role="tabpanel">
                        <h4>About This Route</h4>
                        <p><?php echo nl2br(htmlspecialchars($route['description'])); ?></p>
                    </div>
                    <div class="tab-pane fade" id="schedule" role="tabpanel">
                        <h4>Daily Schedule</h4>
                        <p>This is a sample schedule. Please confirm exact times during booking.</p>
                        <ul class="list-group">
                            <li class="list-group-item">Departure: 8:00 AM - Arrival: 10:00 AM</li>
                            <li class="list-group-item">Departure: 2:00 PM - Arrival: 4:00 PM</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card shadow-sm booking-widget">
                <div class="card-body">
                    <h3 class="card-title">Book Your Trip</h3>
                    <hr>
                    <form action="ferry-booking.php" method="POST">
                        <input type="hidden" name="route_id" value="<?php echo $route['id']; ?>">
                        <div class="mb-3">
                            <label class="form-label">Trip Type</label>
                            <select class="form-select" name="trip_type">
                                <option value="one-way">One-Way</option>
                                <option value="round-trip">Round-Trip</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="departure_date" class="form-label">Departure Date</label>
                            <input type="date" class="form-control" id="departure_date" name="departure_date" required>
                        </div>
                        <div class="mb-3">
                            <label for="passengers" class="form-label">Passengers</label>
                            <input type="number" class="form-control" id="passengers" name="passengers" value="1" min="1" required>
                        </div>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary btn-lg">Book Tickets</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
