<?php 
include 'header.php'; 

// Determine which view to show. Default to 'all'.
$view = $_GET['view'] ?? 'all';

// Prepare the SQL query based on the selected view
if ($view === 'topups') {
    $sql = "SELECT * FROM transactions WHERE user_id = ? AND transaction_type IN ('Top-up', 'Admin Credit') ORDER BY created_at DESC";
} else {
    $sql = "SELECT * FROM transactions WHERE user_id = ? ORDER BY created_at DESC";
}

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Transaction History</h1>
</div>

<ul class="nav nav-tabs mb-3">
    <li class="nav-item">
        <a class="nav-link <?php if($view == 'all') echo 'active'; ?>" href="?view=all">All Transactions</a>
    </li>
    <li class="nav-item">
        <a class="nav-link <?php if($view == 'topups') echo 'active'; ?>" href="?view=topups">Top-Up History</a>
    </li>
</ul>


<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <?php if ($view === 'topups'): ?>
                        <tr>
                            <th>Date Submitted</th>
                            <th>Amount</th>
                            <th>Method</th>
                            <th>Reference #</th>
                            <th class="text-center">Proof</th>
                            <th>Status</th>
                            <th>Admin Notes</th>
                        </tr>
                    <?php else: ?>
                        <tr>
                            <th>Date</th>
                            <th>Transaction Type</th>
                            <th>Amount</th>
                            <th>Method</th>
                            <th>Status</th>
                        </tr>
                    <?php endif; ?>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): ?>
                        <?php while($row = $result->fetch_assoc()):
                            // Determine color and prefix for the amount
                            $isDebit = in_array($row['transaction_type'], ['Booking Payment', 'Admin Debit']);
                            $amount_class = $isDebit ? 'text-danger' : 'text-success';
                            $amount_prefix = $isDebit ? '-' : '+';
                            
                            // Determine badge color for status
                            $status_badge = 'bg-secondary';
                            if ($row['status'] == 'Completed') $status_badge = 'bg-success';
                            if ($row['status'] == 'Pending') $status_badge = 'bg-warning text-dark';
                            if ($row['status'] == 'Rejected') $status_badge = 'bg-danger';
                        ?>
                            <tr>
                                <td><?php echo date("M d, Y H:i A", strtotime($row['created_at'])); ?></td>

                                <?php if ($view === 'topups'): ?>
                                    <td class="<?php echo $amount_class; ?> fw-bold"><?php echo $amount_prefix; ?> ₱<?php echo number_format($row['amount'], 2); ?></td>
                                    <td><?php echo htmlspecialchars($row['payment_method'] ?? ''); // FIX: Added ?? '' ?></td>
                                    <td><?php echo htmlspecialchars($row['reference_number'] ?? ''); // FIX: Added ?? '' ?></td>
                                    <td class="text-center">
                                        <?php if(!empty($row['proof_of_payment_url'])): ?>
                                        <a href="../<?php echo htmlspecialchars($row['proof_of_payment_url']); ?>" target="_blank" class="btn btn-sm btn-outline-primary">View</a>
                                        <?php else: echo 'N/A'; endif; ?>
                                    </td>
                                    <td><span class="badge <?php echo $status_badge; ?>"><?php echo $row['status']; ?></span></td>
                                    <td><small class="text-muted"><?php echo htmlspecialchars($row['admin_notes'] ?? ''); // FIX: Added ?? '' ?></small></td>
                                <?php else: ?>
                                    <td><?php echo htmlspecialchars($row['transaction_type']); ?></td>
                                    <td class="<?php echo $amount_class; ?> fw-bold"><?php echo $amount_prefix; ?> ₱<?php echo number_format($row['amount'], 2); ?></td>
                                    <td><?php echo htmlspecialchars($row['payment_method'] ?? ''); // FIX: Added ?? '' ?></td>
                                    <td><span class="badge <?php echo $status_badge; ?>"><?php echo $row['status']; ?></span></td>
                                <?php endif; ?>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" class="text-center text-muted p-4">No transactions found in this view.</td>
                        </tr>
                    <?php endif; $stmt->close(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
