<?php 
include 'header.php'; 

// More robust checks to see if automated gateways are enabled AND configured with API keys
$is_paymongo_enabled = (isset($site_settings['paymongo_enabled']) && $site_settings['paymongo_enabled'] == '1' && !empty($site_settings['paymongo_secret_key']));
$is_paypal_enabled = (isset($site_settings['paypal_enabled']) && $site_settings['paypal_enabled'] == '1' && !empty($site_settings['paypal_client_id']));
$automated_enabled = $is_paymongo_enabled || $is_paypal_enabled;
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Top-Up Wallet</h1>
</div>
<div class="row justify-content-center">
    <div class="col-lg-7">
        <div id="payment-success-alert" class="alert alert-success" style="display: none;"></div>
        <?php if(isset($_GET['payment']) && $_GET['payment'] == 'cancelled'): ?>
            <div class="alert alert-warning">The payment was cancelled. Please try again.</div>
        <?php endif; ?>
        
        <?php if ($automated_enabled): ?>
        <div class="card shadow-sm mb-4">
            <div class="card-header fw-bold">Automated Top-Up (Instant)</div>
            <div class="card-body">
                <div class="mb-3"><label class="form-label">Enter Amount (PHP)</label><div class="input-group"><span class="input-group-text">₱</span><input type="number" id="topup-amount" class="form-control form-control-lg" min="100" step="0.01" placeholder="Minimum 100.00" value="100"></div></div><hr>
                <?php if ($is_paymongo_enabled): ?>
                <form action="../create-payment.php" method="POST" class="d-grid gap-2">
                    <input type="hidden" name="amount" id="paymongo-amount">
                    <button type="submit" name="method" value="gcash" class="btn btn-primary btn-lg" onclick="document.getElementById('paymongo-amount').value = document.getElementById('topup-amount').value;"><i class="bi bi-wallet-fill"></i> Pay with GCash</button>
                </form>
                <?php endif; ?>
                <?php if ($is_paypal_enabled): ?><div id="paypal-button-container" class="mt-2"></div><?php endif; ?>
            </div>
        </div>
        <p class="text-center my-3">-- OR --</p>
        <?php endif; ?>
        
        <div class="card shadow-sm">
            <div class="card-header <?php if(!$automated_enabled) echo 'fw-bold'; ?>">
                <a class="text-decoration-none text-dark" data-bs-toggle="collapse" href="#manualUpload" role="button" aria-expanded="<?php echo !$automated_enabled ? 'true' : 'false'; ?>">Manual Top-Up (Requires Admin Approval)</a>
            </div>
            <div class="collapse <?php if(!$automated_enabled) echo 'show'; ?>" id="manualUpload">
                <div class="card-body">
                    <p>Select a payment method to view instructions, then submit your payment details below.</p>
                    <div id="payment-details-container" class="mb-4"></div>
                    <?php include 'top-up-manual-form.php'; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    <?php if ($is_paypal_enabled): ?>
    paypal.Buttons({ /* ... PayPal button logic ... */ }).render('#paypal-button-container');
    <?php endif; ?>
    const paymentMethodSelect = document.getElementById('paymentMethodSelect');
    const detailsContainer = document.getElementById('payment-details-container');
    if (paymentMethodSelect) {
        paymentMethodSelect.addEventListener('change', function() {
            const methodId = this.value;
            if (!methodId) { detailsContainer.innerHTML = ''; return; }
            detailsContainer.innerHTML = '<p class="text-muted">Loading details...</p>';
            fetch(`get-payment-method-details.php?id=${methodId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.error) { detailsContainer.innerHTML = `<div class="alert alert-danger">${data.error}</div>`; return; }
                    let detailsHtml = '<div class="p-3 bg-light rounded">';
                    if(data.qr_code_url) { detailsHtml += `<img src="../${data.qr_code_url}" class="img-thumbnail mb-3" style="max-width: 200px;">`; }
                    detailsHtml += `<p class="mb-1"><strong>Account Name:</strong> ${data.account_name}</p><p class="mb-1"><strong>Number:</strong> ${data.account_number}</p><hr><p class="mb-0"><strong>Instructions:</strong><br>${data.instructions.replace(/\n/g, '<br>')}</p></div>`;
                    detailsContainer.innerHTML = detailsHtml;
                }).catch(error => { detailsContainer.innerHTML = '<div class="alert alert-danger">Could not load details.</div>'; });
        });
    }
});
</script>
<?php include 'footer.php'; ?>
