<?php
// 1. INCLUDE THE DASHBOARD HEADER
// Handles security, DB, user data, and the top navbar.
include 'header.php';

// --- Page-Specific Logic Starts Here ---
// The $user_id variable is available from header.php

// 2. FETCH ALL REVIEWS by the logged-in user
// This complex query joins with multiple tables to get the name of the item that was reviewed.
$stmt = $conn->prepare("
    SELECT 
        r.id,
        r.review_text,
        r.rating,
        r.is_visible,
        r.created_at,
        r.item_type,
        COALESCE(t.title, h.name) as item_name
    FROM reviews r
    LEFT JOIN tours t ON r.item_id = t.id AND r.item_type IN ('tour', 'service')
    LEFT JOIN hotels h ON r.item_id = h.id AND r.item_type = 'hotel'
    WHERE r.user_id = ?
    ORDER BY r.created_at DESC
");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$reviews_result = $stmt->get_result();
$reviews = $reviews_result->fetch_all(MYSQLI_ASSOC);
$stmt->close();

$review_icons = ['tour' => 'bi-compass-fill', 'service' => 'bi-tools', 'hotel' => 'bi-building'];

?>

<div class="container my-5">
    <div class="dashboard-content">
        <h1 class="h2 mb-4">My Reviews</h1>

        <div class="card shadow-sm">
            <div class="card-header bg-light">
                <h5 class="mb-0"><i class="bi bi-star-fill me-2"></i>Your Submitted Reviews</h5>
            </div>

            <?php if (!empty($reviews)): ?>
                <div class="list-group list-group-flush">
                    <?php foreach ($reviews as $review): ?>
                        <div class="list-group-item p-3">
                            <div class="d-flex w-100 justify-content-between mb-2">
                                <div>
                                    <h6 class="mb-0">
                                        <i class="bi <?php echo $review_icons[strtolower($review['item_type'])] ?? 'bi-geo-alt'; ?> me-1 text-primary"></i>
                                        Review for: <?php echo htmlspecialchars($review['item_name']); ?>
                                    </h6>
                                    <small class="text-muted">Submitted on <?php echo date('F j, Y', strtotime($review['created_at'])); ?></small>
                                </div>
                                <div class="text-warning h5">
                                    <?php for($i=0; $i < $review['rating']; $i++) echo '<i class="bi bi-star-fill"></i>'; ?>
                                </div>
                            </div>
                            <p class="mb-1 text-muted fst-italic">"<?php echo nl2br(htmlspecialchars($review['review_text'])); ?>"</p>
                            <div>
                                <?php if ($review['is_visible']): ?>
                                    <span class="badge bg-success">Published</span>
                                <?php else: ?>
                                    <span class="badge bg-warning">Pending Approval</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <div class="card-body text-center p-5">
                    <p class="text-muted mb-0">You have not submitted any reviews yet.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
