<?php
require_once '../includes/db.php';
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Authentication required.']);
    exit();
}

$method_id = intval($_GET['id'] ?? 0);
if ($method_id <= 0) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid ID.']);
    exit();
}

$stmt = $conn->prepare("SELECT * FROM payment_methods WHERE id = ? AND is_active = 1");
$stmt->bind_param("i", $method_id);
$stmt->execute();
$result = $stmt->get_result();
$method_details = $result->fetch_assoc();

if ($method_details) {
    echo json_encode($method_details);
} else {
    http_response_code(404);
    echo json_encode(['error' => 'Payment method not found.']);
}
?>
