<?php
include 'header.php'; // Includes partner session check

$message = '';
// Handle file upload
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['document_file'])) {
    $document_type = trim($_POST['document_type']);
    
    if (empty($document_type)) {
        $message = '<div class="alert alert-danger">Please select a document type.</div>';
    } else {
        $target_dir = "../uploads/documents/" . $partner_id . "/";
        if (!is_dir($target_dir)) { mkdir($target_dir, 0755, true); }
        
        $file_name = uniqid() . '-' . basename($_FILES["document_file"]["name"]);
        $target_file = $target_dir . $file_name;
        
        // For security, it's better to check file types and sizes.
        if (move_uploaded_file($_FILES["document_file"]["tmp_name"], $target_file)) {
            $file_url = str_replace('../', '', $target_file);
            $stmt = $conn->prepare("INSERT INTO partner_documents (partner_id, document_type, file_url) VALUES (?, ?, ?)");
            $stmt->bind_param("iss", $partner_id, $document_type, $file_url);
            if ($stmt->execute()) {
                $message = '<div class="alert alert-success">Document uploaded successfully and is awaiting review.</div>';
            }
        } else {
            $message = '<div class="alert alert-danger">Sorry, there was an error uploading your file.</div>';
        }
    }
}

// Fetch already submitted documents
$docs_result = $conn->prepare("SELECT * FROM partner_documents WHERE partner_id = ? ORDER BY upload_date DESC");
$docs_result->bind_param("i", $partner_id);
$docs_result->execute();
$submitted_docs = $docs_result->get_result();
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Verification Documents</h1>
</div>
<?php echo $message; ?>

<div class="row">
    <div class="col-md-6 mb-4">
        <div class="card shadow-sm">
            <div class="card-header">Upload a New Document</div>
            <div class="card-body">
                <form method="POST" enctype="multipart/form-data">
                    <div class="mb-3">
                        <label class="form-label">Document Type</label>
                        <select name="document_type" class="form-select" required>
                            <option value="">-- Select Type --</option>
                            <option value="Business Permit">Business Permit</option>
                            <option value="DTI/SEC Registration">DTI/SEC Registration</option>
                            <option value="BIR Certificate">BIR Certificate of Registration</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Select File (PDF, JPG, PNG)</label>
                        <input type="file" name="document_file" class="form-control" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Upload Document</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-6 mb-4">
        <div class="card shadow-sm">
            <div class="card-header">My Submitted Documents</div>
            <div class="list-group list-group-flush">
                <?php if ($submitted_docs->num_rows > 0): while($doc = $submitted_docs->fetch_assoc()): ?>
                <div class="list-group-item d-flex justify-content-between align-items-center">
                    <div>
                        <strong><?php echo htmlspecialchars($doc['document_type']); ?></strong><br>
                        <small class="text-muted">Submitted: <?php echo date('M d, Y', strtotime($doc['upload_date'])); ?></small>
                    </div>
                    <span class="badge bg-<?php if($doc['status']=='Approved') echo 'success'; elseif($doc['status']=='Rejected') echo 'danger'; else echo 'warning'; ?>"><?php echo $doc['status']; ?></span>
                </div>
                <?php endwhile; else: ?>
                <div class="list-group-item text-center text-muted p-4">You have not submitted any documents yet.</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
