<?php
include 'header.php';

// Determine which view to show
$view = $_GET['view'] ?? 'upcoming';

// --- DYNAMIC DATA FETCHING BASED ON ROLE ---
if ($partner_role == 'tour_partner') {
    $date_column = 'b.booking_date';
    $main_table = 'bookings b';
    $join_table = 'tours t';
    $join_condition = 'b.tour_id = t.id';
    $partner_filter = 't.partner_id';
    $guest_name_column = 'b.customer_name';
    $guest_count_column = 'b.num_travelers';
    $item_name_column = 't.title';
} elseif ($partner_role == 'hotel_partner') {
    $date_column = 'b.check_in_date';
    $main_table = 'hotel_bookings b';
    $join_table = 'hotels h';
    $join_condition = 'b.hotel_id = h.id';
    $partner_filter = 'h.partner_id';
    $guest_name_column = 'u.full_name'; // From users table
    $guest_count_column = 'b.num_guests';
    $item_name_column = 'h.name';
}

$date_filter = ($view == 'upcoming') ? "$date_column >= CURDATE()" : "$date_column < CURDATE()";

$sql = "SELECT b.*, $guest_name_column as customer_name, $guest_count_column as guest_count, $item_name_column as item_name
        FROM $main_table
        JOIN $join_table ON $join_condition " .
       ($partner_role == 'hotel_partner' ? "JOIN users u ON b.user_id = u.id " : "") .
       "WHERE $partner_filter = ? AND b.payment_status = 'Paid' AND $date_filter
        ORDER BY $date_column DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $partner_id);
$stmt->execute();
$result = $stmt->get_result();
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">My Bookings</h1>
</div>

<ul class="nav nav-tabs mb-3">
    <li class="nav-item"><a class="nav-link <?php echo $view == 'upcoming' ? 'active' : ''; ?>" href="?view=upcoming">Upcoming</a></li>
    <li class="nav-item"><a class="nav-link <?php echo $view == 'past' ? 'active' : ''; ?>" href="?view=past">Past & Completed</a></li>
</ul>

<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-dark">
                    <tr><th>Booking ID</th><th>Customer Name</th><th>Property Booked</th><th>Date</th><th>Guests</th><th>Status</th></tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): while ($booking = $result->fetch_assoc()): ?>
                    <tr>
                        <td>#<?php echo $booking['id']; ?></td>
                        <td><?php echo htmlspecialchars($booking['customer_name']); ?></td>
                        <td><?php echo htmlspecialchars($booking['item_name']); ?></td>
                        <td><?php echo date('M d, Y', strtotime($booking[$partner_role == 'tour_partner' ? 'booking_date' : 'check_in_date'])); ?></td>
                        <td><?php echo $booking['guest_count']; ?></td>
                        <td><span class="badge bg-success"><?php echo htmlspecialchars($booking['status']); ?></span></td>
                    </tr>
                    <?php endwhile; else: ?>
                    <tr><td colspan="6" class="text-center text-muted p-4">No <?php echo $view; ?> bookings found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php include 'footer.php'; ?>
