<?php
require_once '../includes/db.php';

// Security check and full data fetch for the partner
if (!isset($_SESSION['user_id']) || !isset($_SESSION['user_role']) || !in_array($_SESSION['user_role'], ['tour_partner', 'hotel_partner'])) {
    header("Location: ../login.php");
    exit();
}
$partner_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $partner_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();
if (!$user) { session_destroy(); header("Location: ../login.php"); exit(); }
$partner_name = $user['full_name'];
$partner_role = $user['role'];

// Fetch site settings for use in other pages
$settings_result = $conn->query("SELECT * FROM site_settings");
$site_settings = [];
if ($settings_result) { while ($row = $settings_result->fetch_assoc()) { $site_settings[$row['setting_name']] = $row['setting_value']; } }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Partner Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="/css/style.css">
</head>
<body>
<nav class="navbar navbar-dark bg-dark sticky-top d-flex flex-md-nowrap p-0 shadow">
    <a class="navbar-brand col-md-3 col-lg-2 me-0 px-3 fs-6" href="index.php"><i class="bi bi-briefcase-fill"></i> Partner Dashboard</a>
    <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu"></button>
    <div class="navbar-nav"><div class="nav-item text-nowrap d-flex align-items-center">
        <?php if (!empty($user['profile_image_url'])): ?><img src="../<?php echo htmlspecialchars($user['profile_image_url']); ?>" class="rounded me-2" style="width: 32px; height: 32px; object-fit: cover;"><?php endif; ?>
        <span class="px-3 text-white"><?php echo htmlspecialchars($partner_name); ?></span>
    </div></div>
</nav>
<div class="container-fluid">
    <div class="row">
        <nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block bg-light sidebar collapse vh-100 border-end">
            <div class="position-sticky pt-3">
                <ul class="nav flex-column">
                    <li class="nav-item"><a class="nav-link" href="index.php"><i class="bi bi-grid-1x2-fill me-2"></i> Dashboard</a></li>
                    <li class="nav-item"><a class="nav-link" href="my-bookings.php"><i class="bi bi-card-checklist me-2"></i> Bookings</a></li>
                    <li class="nav-item"><a class="nav-link" href="earnings.php"><i class="bi bi-cash-stack me-2"></i> Earnings</a></li>
                </ul>
                <h6 class="sidebar-heading px-3 mt-4 mb-1 text-muted"><span>Manage Listings</span></h6>
                <ul class="nav flex-column mb-2">
                    <?php if ($partner_role == 'tour_partner'): ?><li class="nav-item"><a class="nav-link" href="manage-tours.php"><i class="bi bi-compass me-2"></i> My Tours</a></li><?php endif; ?>
                    <?php if ($partner_role == 'hotel_partner'): ?><li class="nav-item"><a class="nav-link" href="manage-hotels.php"><i class="bi bi-building me-2"></i> My Hotels</a></li><?php endif; ?>
                </ul>
                <h6 class="sidebar-heading px-3 mt-4 mb-1 text-muted"><span>Account</span></h6>
                <ul class="nav flex-column mb-2">
                    <li class="nav-item"><a class="nav-link" href="edit-profile.php"><i class="bi bi-person-fill-gear me-2"></i> My Profile</a></li>
                    <li class="nav-item"><a class="nav-link" href="submit-documents.php"><i class="bi bi-file-earmark-check me-2"></i> Verification</a></li>
                </ul>
                <ul class="nav flex-column mt-auto mb-2"><li class="nav-item"><a class="nav-link text-danger" href="../logout.php"><i class="bi bi-box-arrow-right me-2"></i> Log Out</a></li></ul>
            </div>
        </nav>
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
