<?php 
include 'includes/header.php'; 

// --- DATA FETCHING FOR HOMEPAGE WIDGETS ---
// Fetch airports for the flight search form
$airports_result = $conn->query("SELECT * FROM airports ORDER BY city ASC");
$airports = [];
if ($airports_result) { while ($row = $airports_result->fetch_assoc()) { $airports[] = $row; } }

// Fetch ferry ports for the ferry search form
$ports_result = $conn->query("SELECT * FROM ferry_ports ORDER BY city ASC");
$ports = [];
if ($ports_result) { while ($row = $ports_result->fetch_assoc()) { $ports[] = $row; } }
?>

<?php
// Set a fallback image if the setting is empty
$hero_bg = !empty($site_settings['hero_background_url']) ? $site_settings['hero_background_url'] : 'https://images.unsplash.com/photo-147651452553-07fb3b4ae5f1?q=80&w=2070';
?>
<div class="hero-section text-white text-center" style="background: url('<?php echo htmlspecialchars($hero_bg); ?>') no-repeat center center; background-size: cover;">
    <div class="container py-5">
        <h1 class="display-4 fw-bold">Your Adventure Starts Here</h1>
        <p class="lead col-lg-8 mx-auto">Discover and book amazing tours, hotels, flights, and ferries all in one place.</p>
        
        <div class="card shadow-lg mt-4">
            <div class="card-header">
                <ul class="nav nav-tabs card-header-tabs" id="booking-tabs" role="tablist">
                    <li class="nav-item" role="presentation"><button class="nav-link active" data-bs-toggle="tab" data-bs-target="#flights-panel" type="button"><i class="bi bi-airplane"></i> Flights</button></li>
                    <li class="nav-item" role="presentation"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#ferries-panel" type="button"><i class="bi bi-tsunami"></i> Ferries</button></li>
                    <li class="nav-item" role="presentation"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#hotels-panel" type="button"><i class="bi bi-building"></i> Hotels</button></li>
                    <li class="nav-item" role="presentation"><button class="nav-link" data-bs-toggle="tab" data-bs-target="#tours-panel" type="button"><i class="bi bi-compass"></i> Tours & Services</button></li>
                </ul>
            </div>
            <div class="card-body">
                <div class="tab-content text-start">
                    <div class="tab-pane fade show active" id="flights-panel"><form action="flights.php" method="POST"><div class="row align-items-end g-3"><div class="col-lg"><label class="form-label">From</label><select name="origin_id" class="form-select" required><?php foreach ($airports as $airport) echo '<option value="'.$airport['id'].'">'.htmlspecialchars($airport['city'] . ' (' . $airport['airport_code'] . ')').'</option>'; ?></select></div><div class="col-lg"><label class="form-label">To</label><select name="destination_id" class="form-select" required><?php foreach ($airports as $airport) echo '<option value="'.$airport['id'].'">'.htmlspecialchars($airport['city'] . ' (' . $airport['airport_code'] . ')').'</option>'; ?></select></div><div class="col-lg-3"><label class="form-label">Departure</label><input type="date" name="departure_date" class="form-control" required min="<?php echo date('Y-m-d'); ?>"></div><div class="col-lg-2 d-grid"><input type="hidden" name="trip_type" value="One-way"><input type="hidden" name="num_adults" value="1"><button type="submit" class="btn btn-primary">Request Quote</button></div></div></form></div>
                    <div class="tab-pane fade" id="ferries-panel"><form id="ferrySearchForm"><div class="row align-items-end g-3"><div class="col-lg"><label class="form-label">From</label><select id="ferryOrigin" class="form-select" required><?php foreach ($ports as $port) echo '<option value="'.$port['id'].'">'.htmlspecialchars($port['city'] . ' Port').'</option>'; ?></select></div><div class="col-lg"><label class="form-label">To</label><select id="ferryDestination" class="form-select" required><?php foreach ($ports as $port) echo '<option value="'.$port['id'].'">'.htmlspecialchars($port['city'] . ' Port').'</option>'; ?></select></div><div class="col-lg-3"><label class="form-label">Departure</label><input type="date" id="ferryDate" class="form-control" required min="<?php echo date('Y-m-d'); ?>"></div><div class="col-lg-2 d-grid"><button type="submit" class="btn btn-primary">Search Ferries</button></div></div></form></div>
                    <div class="tab-pane fade" id="hotels-panel"><form id="hotelSearchForm"><div class="row align-items-end g-3"><div class="col-lg-10"><label class="form-label">Destination</label><input type="text" id="hotelLocation" class="form-control" placeholder="e.g., Cebu, Boracay, Manila" required></div><div class="col-lg-2 d-grid"><button type="submit" class="btn btn-primary">Search Hotels</button></div></div></form></div>
                    <div class="tab-pane fade" id="tours-panel"><form id="tourSearchForm"><div class="row align-items-end g-3"><div class="col-lg-10"><label class="form-label">Destination or Keyword</label><input type="text" id="tourKeyword" class="form-control" placeholder="e.g., El Nido, Island Hopping, PSA" required></div><div class="col-lg-2 d-grid"><button type="submit" class="btn btn-primary">Search</button></div></div></form></div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="container my-5">
    <div class="text-center"><h2 class="mb-2">Popular Tours & Services</h2><p class="lead text-muted mb-4">Experiences loved by our travelers.</p></div>
    <div class="row">
        <?php $tours_result = $conn->query("SELECT * FROM tours WHERE is_featured = 1 LIMIT 3"); if ($tours_result && $tours_result->num_rows > 0): while($row = $tours_result->fetch_assoc()): ?>
            <div class="col-lg-4 col-md-6 mb-4"><div class="card h-100 tour-card"><a href="service-details.php?id=<?php echo $row['id']; ?>"><img src="<?php echo htmlspecialchars($row['image_url']); ?>" class="card-img-top"></a><div class="card-body d-flex flex-column"><h5 class="card-title"><?php echo htmlspecialchars($row['title']); ?></h5><p class="card-text text-muted"><i class="bi bi-geo-alt-fill"></i> <?php echo htmlspecialchars($row['location']); ?></p><h6 class="card-subtitle mb-3 fw-bold">From ₱<?php echo number_format($row['price'], 2); ?></h6><a href="service-details.php?id=<?php echo $row['id']; ?>" class="btn btn-primary mt-auto">View Details</a></div></div></div>
        <?php endwhile; else: echo "<p class='text-center'>No featured tours or services available.</p>"; endif; ?>
    </div>
    <div class="text-center mt-5"><h2 class="mb-2">Recommended Hotels</h2><p class="lead text-muted mb-4">Hand-picked stays for a perfect vacation.</p></div>
    <div class="row">
        <?php $hotels_result = $conn->query("SELECT * FROM hotels WHERE is_recommended = 1 LIMIT 3"); if ($hotels_result && $hotels_result->num_rows > 0): while($hotel = $hotels_result->fetch_assoc()): ?>
            <div class="col-lg-4 col-md-6 mb-4"><div class="card h-100 tour-card"><a href="hotel-details.php?id=<?php echo $hotel['id']; ?>"><img src="<?php echo htmlspecialchars($hotel['main_image_url'] ?? ''); ?>" class="card-img-top"></a><div class="card-body d-flex flex-column"><h5 class="card-title"><?php echo htmlspecialchars($hotel['name']); ?></h5><p class="card-text text-muted"><i class="bi bi-geo-alt-fill"></i> <?php echo htmlspecialchars($hotel['location']); ?></p><div class="text-warning mb-2"><?php for($i=0; $i<$hotel['star_rating']; $i++) echo '<i class="bi bi-star-fill"></i>'; ?></div><a href="hotel-details.php?id=<?php echo $hotel['id']; ?>" class="btn btn-primary mt-auto">View Rooms</a></div></div></div>
        <?php endwhile; else: echo "<p class='text-center'>No recommended hotels available.</p>"; endif; ?>
    </div>
</div>

<div class="bg-light py-5">
    <div class="container">
        <h2 class="text-center mb-4">What Our Clients Say</h2>
        <?php $reviews_result = $conn->query("SELECT * FROM reviews WHERE is_visible = 1 AND is_verified = 1 ORDER BY id DESC LIMIT 6"); if ($reviews_result && $reviews_result->num_rows > 0): ?>
            <div id="reviewCarousel" class="carousel slide review-carousel" data-bs-ride="carousel">
                <div class="carousel-inner">
                    <?php $first = true; while($review = $reviews_result->fetch_assoc()): ?>
                    <div class="carousel-item <?php if($first) { echo 'active'; $first = false; } ?>"><div class="review-carousel-item"><div class="review-card text-center"><p class="fs-5 fst-italic">"<?php echo htmlspecialchars($review['review_text']); ?>"</p><div class="text-warning my-2"><?php for ($i=0; $i < $review['rating']; $i++): ?><i class="bi bi-star-fill"></i><?php endfor; ?></div><h5 class="fw-bold mt-3 mb-1">- <?php echo htmlspecialchars($review['display_name_publicly'] ? $review['customer_name'] : 'A Verified Traveler'); ?></h5><span class="badge bg-success"><i class="bi bi-patch-check-fill"></i> Verified Booking</span></div></div></div>
                    <?php endwhile; ?>
                </div>
                <button class="carousel-control-prev" type="button" data-bs-target="#reviewCarousel" data-bs-slide="prev"><span class="carousel-control-prev-icon"></span></button>
                <button class="carousel-control-next" type="button" data-bs-target="#reviewCarousel" data-bs-slide="next"><span class="carousel-control-next-icon"></span></button>
            </div>
        <?php else: echo "<p class='text-center text-muted'>No client reviews to display yet.</p>"; endif; ?>
    </div>
</div>

<div class="container my-5">
    <div class="text-center"><h2 class="mb-2">From Our Blog</h2><p class="lead text-muted mb-4">Tips, guides, and stories to inspire your next journey.</p></div>
    <div class="row">
    <?php $articles_result = $conn->query("SELECT * FROM articles ORDER BY publish_date DESC LIMIT 3"); if ($articles_result && $articles_result->num_rows > 0): while($article = $articles_result->fetch_assoc()): ?>
        <div class="col-lg-4 col-md-6 mb-4"><div class="card h-100 tour-card shadow-sm"><a href="article-details.php?id=<?php echo $article['id']; ?>"><img src="<?php echo htmlspecialchars($article['image_url']); ?>" class="card-img-top"></a><div class="card-body d-flex flex-column"><h5 class="card-title"><a href="article-details.php?id=<?php echo $article['id']; ?>" class="text-dark text-decoration-none"><?php echo htmlspecialchars($article['title']); ?></a></h5><p class="card-text flex-grow-1"><?php echo substr(strip_tags($article['content']), 0, 100); ?>...</p><a href="article-details.php?id=<?php echo $article['id']; ?>" class="btn btn-primary mt-auto">Read More</a></div><div class="card-footer d-flex justify-content-end gap-3 small text-muted"><span><i class="bi bi-eye-fill"></i> <?php echo $article['view_count'] ?? 0; ?></span><span><i class="bi bi-heart-fill"></i> <?php echo $article['like_count'] ?? 0; ?></span></div></div></div>
    <?php endwhile; endif; ?>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('hotelSearchForm')?.addEventListener('submit', function(e) { e.preventDefault(); const loc = document.getElementById('hotelLocation').value; if (loc) window.location.href = `hotels.php?location=${encodeURIComponent(loc)}`; });
    document.getElementById('tourSearchForm')?.addEventListener('submit', function(e) { e.preventDefault(); const key = document.getElementById('tourKeyword').value; if (key) window.location.href = `services.php?keyword=${encodeURIComponent(key)}`; });
    document.getElementById('ferrySearchForm')?.addEventListener('submit', function(e) { e.preventDefault(); const origin = document.getElementById('ferryOrigin').value; const dest = document.getElementById('ferryDestination').value; const date = document.getElementById('ferryDate').value; if (origin && dest && date) window.location.href = `ferries.php?origin=${origin}&destination=${dest}&date=${date}`; });
});
</script>
<?php include 'includes/footer.php'; ?>
