<?php
// A reusable function to send HTML email notifications to customers.
function sendUserNotification($conn, $user_id, $subject, $message_body) {
    
    $settings_result = $conn->query("SELECT setting_value FROM site_settings WHERE setting_name = 'site_name'");
    $site_name = $settings_result->fetch_assoc()['setting_value'] ?? 'DXP Travel & Tours';
    
    $user_result = $conn->query("SELECT email FROM users WHERE id = $user_id");

    if ($user_result->num_rows > 0) {
        $user_email = $user_result->fetch_assoc()['email'];
    } else {
        return false; // Cannot find user to email
    }

    $html_message = "
    <html><head><title>" . htmlspecialchars($subject) . "</title></head>
    <body style='font-family: Arial, sans-serif; line-height: 1.6;'>
        <div style='padding: 20px; border: 1px solid #ddd; border-radius: 5px; max-width: 600px;'>
            <h2>Hello from " . htmlspecialchars($site_name) . "!</h2>
            <p>" . $message_body . "</p>
            <p>You can view all your bookings in your dashboard.</p>
            <p>Thank you!</p>
        </div>
    </body>
    </html>
    ";

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: " . $site_name . " <noreply@" . $_SERVER['HTTP_HOST'] . ">" . "\r\n";

    return mail($user_email, $subject, $html_message, $headers);
}
?>
