<?php
// A reusable function to send HTML email notifications to partners.
function sendPartnerNotification($conn, $partner_id, $subject, $message_body) {
    
    // Fetch site name and partner email from the database
    $site_name = $conn->query("SELECT setting_value FROM site_settings WHERE setting_name = 'site_name'")->fetch_assoc()['setting_value'] ?? 'DXP Travel & Tours';
    $partner_email_result = $conn->query("SELECT email FROM users WHERE id = $partner_id");

    if ($partner_email_result->num_rows > 0) {
        $partner_email = $partner_email_result->fetch_assoc()['email'];
    } else {
        return false; // Cannot find partner to email
    }

    // Basic HTML email template
    $html_message = "
    <html><head><title>" . htmlspecialchars($subject) . "</title></head>
    <body style='font-family: Arial, sans-serif; line-height: 1.6;'>
        <div style='padding: 20px; border: 1px solid #ddd; border-radius: 5px; max-width: 600px;'>
            <h2>Hello Partner,</h2>
            <p>" . $message_body . "</p>
            <p>Thank you for partnering with us.</p>
            <p><strong>The " . htmlspecialchars($site_name) . " Team</strong></p>
        </div>
    </body>
    </html>
    ";

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: " . $site_name . " <noreply@" . $_SERVER['HTTP_HOST'] . ">" . "\r\n";

    return mail($partner_email, $subject, $html_message, $headers);
}
?>
