<?php
// The $site_settings variable is available here because header.php is always included first.
$footer_text_raw = $site_settings['site_footer_text'] ?? '© {year} Your Company. All Rights Reserved.';
$footer_text_final = str_replace('{year}', date('Y'), $footer_text_raw);
?>
<footer class="bg-dark text-white pt-5 pb-4">
    <div class="container text-center text-md-start">
        <div class="row">
            <div class="col-md-4 col-lg-4 col-xl-4 mx-auto mt-3">
                <h5 class="text-uppercase mb-4 fw-bold text-primary"><?php echo htmlspecialchars($site_settings['site_name']); ?></h5>
                <p>Crafting unforgettable journeys across the beautiful islands of the Philippines. Let us guide you on your next great adventure.</p>
            </div>
            <div class="col-md-4 col-lg-2 col-xl-2 mx-auto mt-3">
                <h5 class="text-uppercase mb-4 fw-bold">Quick Links</h5>
                <p><a href="services.php" class="text-white text-decoration-none">Tours & Services</a></p>
                <p><a href="hotels.php" class="text-white text-decoration-none">Hotels</a></p>
                <p><a href="articles.php" class="text-white text-decoration-none">Blog</a></p>
                <p><a href="faq.php" class="text-white text-decoration-none">FAQ</a></p>
            </div>
            <div class="col-md-4 col-lg-3 col-xl-3 mx-auto mt-3">
                <h5 class="text-uppercase mb-4 fw-bold">Contact</h5>
                <p><i class="bi bi-geo-alt-fill me-3"></i> <?php echo htmlspecialchars($site_settings['contact_address'] ?? ''); ?></p>
                <p><i class="bi bi-envelope-fill me-3"></i> <?php echo htmlspecialchars($site_settings['contact_email'] ?? ''); ?></p>
                <p><i class="bi bi-telephone-fill me-3"></i> <?php echo htmlspecialchars($site_settings['contact_phone'] ?? ''); ?></p>
            </div>
        </div>
        <hr class="mb-4">
        <div class="row align-items-center"><div class="col-md-12 text-center"><p><?php echo htmlspecialchars($footer_text_final); ?></p></div></div>
    </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<?php echo $site_settings['footer_scripts'] ?? ''; ?>

</body>
</html>
