<?php
// A reusable function to send HTML email notifications to the admin.
function sendAdminNotification($conn, $subject, $message_body) {
    
    // Fetch the site name and recipient email from the database
    $settings_result = $conn->query("SELECT * FROM site_settings WHERE setting_name IN ('site_name', 'recipient_email')");
    $settings = [];
    while ($row = $settings_result->fetch_assoc()) {
        $settings[$row['setting_name']] = $row['setting_value'];
    }
    
    $site_name = $settings['site_name'] ?? 'Your Website';
    $recipient_email = $settings['recipient_email'] ?? null;

    if (!$recipient_email) {
        // Don't try to send an email if no recipient is set
        return false;
    }

    // Basic HTML email template
    $html_message = "
    <html>
    <head>
        <title>" . htmlspecialchars($subject) . "</title>
        <style> body { font-family: Arial, sans-serif; line-height: 1.6; } .container { padding: 20px; border: 1px solid #ddd; border-radius: 5px; max-width: 600px; } </style>
    </head>
    <body>
        <div class='container'>
            <h2>" . htmlspecialchars($site_name) . " Notification</h2>
            <p>" . $message_body . "</p>
            <hr>
            <p><small>This is an automated notification from your website.</small></p>
        </div>
    </body>
    </html>
    ";

    // Set headers for HTML email
    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: " . $site_name . " <noreply@" . $_SERVER['HTTP_HOST'] . ">" . "\r\n";

    // Send the email
    return mail($recipient_email, $subject, $html_message, $headers);
}
?>
