<?php 
include 'includes/header.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) { header("Location: hotels.php"); exit(); }
$hotel_id = intval($_GET['id']);

// Fetch hotel details and partner verification status
$stmt = $conn->prepare("
    SELECT h.*, u.is_verified as partner_verified 
    FROM hotels h 
    LEFT JOIN users u ON h.partner_id = u.id 
    WHERE h.id = ?");
$stmt->bind_param("i", $hotel_id);
$stmt->execute();
$hotel_result = $stmt->get_result();
if ($hotel_result->num_rows === 0) { header("Location: hotels.php"); exit(); }
$hotel = $hotel_result->fetch_assoc();

// Fetch gallery images
$stmt_gallery = $conn->prepare("SELECT * FROM galleries WHERE item_id = ? AND item_type = 'hotel' ORDER BY id ASC");
$stmt_gallery->bind_param("i", $hotel_id);
$stmt_gallery->execute();
$gallery_images = $stmt_gallery->get_result()->fetch_all(MYSQLI_ASSOC);

// --- SHARE BUTTON LOGIC ---
$page_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$share_title = urlencode("Check out this hotel: " . $hotel['name']);
$page_url_encoded = urlencode($page_url);
?>
<main class="container my-5">
    <div id="hotelCarousel" class="carousel slide shadow-lg rounded mb-4" data-bs-ride="carousel">
        <div class="carousel-indicators">
            <button type="button" data-bs-target="#hotelCarousel" data-bs-slide-to="0" class="active"></button>
            <?php foreach (array_keys($gallery_images) as $i): ?>
            <button type="button" data-bs-target="#hotelCarousel" data-bs-slide-to="<?php echo $i + 1; ?>"></button>
            <?php endforeach; ?>
        </div>
        <div class="carousel-inner rounded">
            <div class="carousel-item active">
                <img src="<?php echo htmlspecialchars($hotel['main_image_url'] ?? 'https://via.placeholder.com/1200x500'); ?>" class="d-block w-100 tour-details-img" alt="Main image">
            </div>
            <?php foreach ($gallery_images as $img): ?>
            <div class="carousel-item"><img src="<?php echo htmlspecialchars($img['image_url']); ?>" class="d-block w-100 tour-details-img" alt="Gallery image"></div>
            <?php endforeach; ?>
        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#hotelCarousel" data-bs-slide="prev"><span class="carousel-control-prev-icon"></span></button>
        <button class="carousel-control-next" type="button" data-bs-target="#hotelCarousel" data-bs-slide="next"><span class="carousel-control-next-icon"></span></button>
    </div>

    <h1 class="d-inline-block me-2"><?php echo htmlspecialchars($hotel['name']); ?></h1>
    <?php if ($hotel['partner_verified']): ?>
        <span class="verified-badge fs-6"><i class="bi bi-patch-check-fill"></i> Verified Partner</span>
    <?php endif; ?>
    <p class="lead"><i class="bi bi-geo-alt-fill"></i> <?php echo htmlspecialchars($hotel['location']); ?></p>
    <div class="text-warning mb-2"><?php for($i=0; $i<$hotel['star_rating']; $i++) echo '<i class="bi bi-star-fill"></i>'; ?></div>
    
    <div class="social-share-buttons">
        <strong>Share this hotel:</strong>
        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo $page_url_encoded; ?>" target="_blank" class="share-facebook" title="Share on Facebook"><i class="bi bi-facebook"></i></a>
        <a href="https://twitter.com/intent/tweet?url=<?php echo $page_url_encoded; ?>&text=<?php echo $share_title; ?>" target="_blank" class="share-twitter" title="Share on Twitter"><i class="bi bi-twitter"></i></a>
        <a href="mailto:?subject=<?php echo $share_title; ?>&body=Check%20out%20this%20hotel:%20<?php echo $page_url_encoded; ?>" class="share-email" title="Share via Email"><i class="bi bi-envelope-fill"></i></a>
    </div>
    <hr>
    <h4>About This Hotel</h4>
    <p><?php echo nl2br(htmlspecialchars($hotel['description'])); ?></p>
    <?php if(!empty($hotel['amenities'])): ?>
    <h4>Amenities</h4>
    <p><?php $amenities = explode(',', $hotel['amenities']); foreach($amenities as $amenity) echo '<span class="badge bg-secondary me-1">'.htmlspecialchars(trim($amenity)).'</span>'; ?></p>
    <?php endif; ?>
    
    <hr class="my-5">

    <h2 class="text-center mb-4">Select Your Room & Rate</h2>
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <?php
            $stmt_rooms = $conn->prepare("SELECT * FROM hotel_rooms WHERE hotel_id = ?");
            $stmt_rooms->bind_param("i", $hotel_id);
            $stmt_rooms->execute();
            $rooms_result = $stmt_rooms->get_result();
            if ($rooms_result->num_rows > 0): while($room = $rooms_result->fetch_assoc()):
            ?>
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light">
                    <h4 class="mb-0"><?php echo htmlspecialchars($room['room_type_name']); ?></h4>
                    <p class="mb-0 text-muted"><i class="bi bi-people-fill"></i> Good for <?php echo $room['max_occupancy']; ?> guests</p>
                </div>
                <div class="list-group list-group-flush">
                    <?php
                    $stmt_rates = $conn->prepare("SELECT * FROM hotel_room_rates WHERE room_id = ? AND is_active = 1 ORDER BY price_per_night ASC");
                    $stmt_rates->bind_param("i", $room['id']);
                    $stmt_rates->execute();
                    $rates_result = $stmt_rates->get_result();
                    while($rate = $rates_result->fetch_assoc()):
                    ?>
                    <div class="list-group-item">
                        <div class="row align-items-center">
                            <div class="col-md-6"><strong><?php echo htmlspecialchars($rate['rate_name']); ?></strong></div>
                            <div class="col-md-3 text-md-end">
                                <span class="fs-4 fw-bold text-success">₱<?php echo number_format($rate['price_per_night'], 2); ?></span>
                                <span class="text-muted">/ night</span>
                            </div>
                            <div class="col-md-3 text-md-end mt-2 mt-md-0">
                                <a href="hotel-booking.php?rate_id=<?php echo $rate['id']; ?>" class="btn btn-primary">Book Now</a>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
            </div>
            <?php endwhile; else: echo '<p class="text-center">No rooms have been listed for this hotel yet.</p>'; endif; ?>
        </div>
    </div>
</main>
<?php include 'includes/footer.php'; ?>
