<?php
// --- LOGIC BLOCK ---
require_once 'includes/db.php';
require_once 'includes/email-sender.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php?redirect=" . urlencode($_SERVER['REQUEST_URI'])); exit();
}

$rate_id = intval($_GET['rate_id'] ?? 0);
if ($rate_id <= 0) { header("Location: hotels.php"); exit(); }

$stmt_info = $conn->prepare("SELECT rr.rate_name, hr.id as room_id, hr.room_type_name, h.id as hotel_id, h.name as hotel_name FROM hotel_room_rates rr JOIN hotel_rooms hr ON rr.room_id = hr.id JOIN hotels h ON hr.hotel_id = h.id WHERE rr.id = ?");
$stmt_info->bind_param("i", $rate_id);
$stmt_info->execute();
$info = $stmt_info->get_result()->fetch_assoc();
if (!$info) { header("Location: hotels.php"); exit(); }

$hotel_id = $info['hotel_id'];
$room_id = $info['room_id'];

$message = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $check_in = $_POST['check_in_date'];
    $check_out = $_POST['check_out_date'];
    $num_guests = intval($_POST['num_guests']);
    if (strtotime($check_out) <= strtotime($check_in)) {
        $message = '<div class="alert alert-danger">Check-out date must be after the check-in date.</div>';
    } else {
        $stmt = $conn->prepare("INSERT INTO hotel_bookings (user_id, hotel_id, room_id, rate_id, check_in_date, check_out_date, num_guests) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("iiiissi", $_SESSION['user_id'], $hotel_id, $room_id, $rate_id, $check_in, $check_out, $num_guests);
        if ($stmt->execute()) {
             $booking_id = $stmt->insert_id;
             $subject = "New Hotel Booking Request (#" . $booking_id . ")";
             $message_body = "A hotel booking request was submitted by " . htmlspecialchars($_SESSION['user_name']) . ".<br><br>Please log in to the admin panel to confirm availability.";
             sendAdminNotification($conn, $subject, $message_body);
             header("Location: dashboard/my-hotel-bookings.php?request=success");
             exit();
        } else {
            $message = '<div class="alert alert-danger">Error submitting your request.</div>';
        }
    }
}

// --- PRESENTATION BLOCK ---
include 'includes/header.php'; 
?>
<main class="container my-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow-lg">
                <div class="card-header"><h3 class="mb-0">Request to Book a Room</h3></div>
                <div class="card-body p-4">
                    <?php echo $message; ?>
                    <h5 class="card-title"><?php echo htmlspecialchars($info['hotel_name']); ?></h5>
                    <p class="card-text mb-1"><strong>Room Type:</strong> <?php echo htmlspecialchars($info['room_type_name']); ?></p>
                    <p class="card-text"><strong>Rate Plan:</strong> <?php echo htmlspecialchars($info['rate_name']); ?></p>
                    <hr>
                    <form method="POST">
                        <div class="row"><div class="col-md-6 mb-3"><label class="form-label">Check-in Date</label><input type="date" name="check_in_date" class="form-control" required min="<?php echo date('Y-m-d'); ?>"></div><div class="col-md-6 mb-3"><label class="form-label">Check-out Date</label><input type="date" name="check_out_date" class="form-control" required min="<?php echo date('Y-m-d', strtotime('+1 day')); ?>"></div></div>
                        <div class="mb-3"><label class="form-label">Number of Guests</label><input type="number" name="num_guests" class="form-control" min="1" required></div>
                        <div class="d-grid"><button type="submit" class="btn btn-primary btn-lg">Submit Booking Request</button></div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>
<?php include 'includes/footer.php'; ?>
