<?php
include 'header.php';

// Fetch all reviews submitted by the current user
$sql = "SELECT r.*, t.title as tour_title 
        FROM reviews r 
        LEFT JOIN tours t ON r.item_id = t.id AND r.item_type = 'tour'
        WHERE r.user_id = ?
        ORDER BY r.id DESC";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$reviews_result = $stmt->get_result();
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">My Submitted Reviews</h1>
</div>

<div class="row">
    <?php if ($reviews_result->num_rows > 0): ?>
        <?php while($review = $reviews_result->fetch_assoc()): ?>
        <div class="col-12 mb-3">
            <div class="card shadow-sm">
                <div class="card-header d-flex justify-content-between">
                    <span>Review for: <strong><?php echo htmlspecialchars($review['tour_title'] ?? 'N/A'); ?></strong></span>
                    <span class="text-muted"><?php echo date("F j, Y", strtotime($review['created_at'])); ?></span>
                </div>
                <div class="card-body">
                    <div class="text-warning mb-2">
                        <?php for ($i=0; $i < $review['rating']; $i++): ?><i class="bi bi-star-fill"></i><?php endfor; ?>
                    </div>
                    <p class="card-text fst-italic">"<?php echo nl2br(htmlspecialchars($review['review_text'])); ?>"</p>
                    <div class="mt-2">
                        <?php echo $review['is_visible'] ? '<span class="badge bg-success">Visible</span>' : '<span class="badge bg-secondary">Pending Approval</span>'; ?>
                        <?php echo $review['is_verified'] ? '<span class="badge bg-primary">Verified Booking</span>' : ''; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endwhile; ?>
    <?php else: ?>
        <div class="col-12">
            <div class="alert alert-info">You have not submitted any reviews yet. After a tour is completed, you can leave a review from your "My Tour Bookings" page.</div>
        </div>
    <?php endif; ?>
</div>

<?php include 'footer.php'; ?>
