<?php 
include 'header.php';

// --- DATA FETCHING FOR WIDGETS ---
$kpi_sql = "SELECT 
    (SELECT COUNT(*) FROM bookings WHERE user_id = ? AND payment_status = 'Paid' AND booking_date >= CURDATE()) + 
    (SELECT COUNT(*) FROM hotel_bookings WHERE user_id = ? AND payment_status = 'Paid' AND check_in_date >= CURDATE()) as upcoming_trips,
    (SELECT COUNT(*) FROM hotel_bookings WHERE user_id = ? AND status = 'Confirmed' AND payment_status = 'Unpaid') + 
    (SELECT COUNT(*) FROM flight_bookings WHERE user_id = ? AND status = 'Quoted' AND payment_status = 'Unpaid') as action_required,
    (SELECT COUNT(*) FROM bookings WHERE user_id = ? AND status = 'Completed') + 
    (SELECT COUNT(*) FROM hotel_bookings WHERE user_id = ? AND status = 'Completed') as completed_trips
";
$stmt_kpi = $conn->prepare($kpi_sql);
$stmt_kpi->bind_param("iiiiii", $user_id, $user_id, $user_id, $user_id, $user_id, $user_id);
$stmt_kpi->execute();
$kpis = $stmt_kpi->get_result()->fetch_assoc();

$recent_activity_sql = "
    (SELECT 'Tour' as type, b.created_at as activity_date, t.title as item_name, b.status, 'my-tour-bookings.php' as link FROM bookings b JOIN tours t ON b.tour_id = t.id WHERE b.user_id = ?)
    UNION ALL
    (SELECT 'Hotel' as type, hb.created_at as activity_date, h.name as item_name, hb.status, 'my-hotel-bookings.php' as link FROM hotel_bookings hb JOIN hotels h ON hb.hotel_id = h.id WHERE hb.user_id = ?)
    UNION ALL
    (SELECT 'Flight' as type, fb.created_at as activity_date, CONCAT(orig.airport_code, ' → ', dest.airport_code) as item_name, fb.status, 'my-flight-bookings.php' as link FROM flight_bookings fb JOIN airports orig ON fb.origin_id = orig.id JOIN airports dest ON fb.destination_id = dest.id WHERE fb.user_id = ?)
    ORDER BY activity_date DESC LIMIT 5";
$stmt_activity = $conn->prepare($recent_activity_sql);
$stmt_activity->bind_param("iii", $user_id, $user_id, $user_id);
$stmt_activity->execute();
$recent_activity_result = $stmt_activity->get_result();
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Dashboard</h1>
    <div class="btn-toolbar mb-2 mb-md-0"><div class="card bg-success text-white"><div class="card-body py-2 px-3"><i class="bi bi-wallet2"></i> Wallet: <strong>₱<?php echo number_format($wallet_balance, 2); ?></strong></div></div></div>
</div>
<div class="row">
    <div class="col-lg-8">
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <h5 class="card-title mb-3">Quick Actions</h5>
                <div class="row g-2">
                    <div class="col-sm-6 col-md-3 mb-2"><a href="../services.php" class="btn btn-outline-primary w-100 quick-action-btn"><i class="bi bi-compass me-2"></i>Tours & Services</a></div>
                    <div class="col-sm-6 col-md-3 mb-2"><a href="../hotels.php" class="btn btn-outline-primary w-100 quick-action-btn"><i class="bi bi-building me-2"></i>Hotels</a></div>
                    <div class="col-sm-6 col-md-3 mb-2"><a href="../flights.php" class="btn btn-outline-primary w-100 quick-action-btn"><i class="bi bi-airplane me-2"></i>Flights</a></div>
                    <div class="col-sm-6 col-md-3 mb-2"><a href="top-up.php" class="btn btn-success w-100 quick-action-btn"><i class="bi bi-wallet2 me-2"></i>Top-Up Wallet</a></div>
                </div>
            </div>
        </div>
        <div class="card shadow-sm">
            <div class="card-header fw-bold"><i class="bi bi-clock-history"></i> Recent Activity</div>
            <div class="list-group list-group-flush">
                <?php if($recent_activity_result && $recent_activity_result->num_rows > 0): while($activity = $recent_activity_result->fetch_assoc()): ?>
                    <a href="<?php echo htmlspecialchars($activity['link']); ?>" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                        <div>
                            <?php if ($activity['type'] == 'Tour') echo '<i class="bi bi-compass-fill text-primary me-2"></i>'; ?>
                            <?php if ($activity['type'] == 'Hotel') echo '<i class="bi bi-building-fill text-info me-2"></i>'; ?>
                            <?php if ($activity['type'] == 'Flight') echo '<i class="bi bi-airplane-fill text-danger me-2"></i>'; ?>
                            <strong><?php echo htmlspecialchars($activity['item_name']); ?></strong><br>
                            <small class="text-muted"><?php echo $activity['type']; ?> Request • <?php echo date("F j, Y", strtotime($activity['activity_date'])); ?></small>
                        </div>
                        <span class="badge bg-secondary rounded-pill"><?php echo htmlspecialchars($activity['status']); ?></span>
                    </a>
                <?php endwhile; else: ?>
                    <div class="list-group-item text-center p-4">You have no recent booking activity.</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="col-lg-4">
        <div class="card kpi-card shadow-sm mb-3" style="--bs-primary: #0d6efd;"><div class="card-body"><div class="row align-items-center"><div class="col"><div class="card-title">Upcoming Trips</div><div class="card-text"><?php echo $kpis['upcoming_trips']; ?></div></div><div class="col-auto"><i class="bi bi-calendar-check kpi-icon"></i></div></div></div></div>
        <div class="card kpi-card shadow-sm mb-3" style="--bs-primary: #ffc107;"><div class="card-body"><div class="row align-items-center"><div class="col"><div class="card-title">Action Required</div><div class="card-text"><?php echo $kpis['action_required']; ?></div></div><div class="col-auto"><i class="bi bi-exclamation-triangle kpi-icon"></i></div></div></div></div>
        <div class="card kpi-card shadow-sm mb-3" style="--bs-primary: #198754;"><div class="card-body"><div class="row align-items-center"><div class="col"><div class="card-title">Adventures Completed</div><div class="card-text"><?php echo $kpis['completed_trips']; ?></div></div><div class="col-auto"><i class="bi bi-flag kpi-icon"></i></div></div></div></div>
        <div class="card shadow-sm"><div class="card-header fw-bold"><i class="bi bi-people-fill"></i> Affiliate Program</div>
            <div class="card-body">
                <p>Earn credit by referring friends!</p>
                <h6 class="text-muted">Your Earnings:</h6>
                <h3 class="fw-bold">₱<?php echo number_format($user['affiliate_earnings'], 2); ?></h3>
                <a href="affiliate.php" class="btn btn-outline-primary btn-sm">Go to Affiliate Hub</a>
            </div>
        </div>
    </div>
</div>
<?php include 'footer.php'; ?>
