<?php 
include 'includes/header.php'; 

// Fetch all articles from the database, newest first
$articles_result = $conn->query("SELECT * FROM articles ORDER BY publish_date DESC");
?>

<div class="container my-5">
    <div class="text-center mb-5">
        <h1 class="display-4">Travel Blog & Articles</h1>
        <p class="lead">Get inspiration and tips for your next adventure from our travel experts.</p>
    </div>

    <div class="row">
        <?php if ($articles_result && $articles_result->num_rows > 0): ?>
            <?php while($article = $articles_result->fetch_assoc()): ?>
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card h-100 tour-card shadow-sm">
                    <a href="article-details.php?id=<?php echo $article['id']; ?>">
                        <img src="<?php echo htmlspecialchars($article['image_url']); ?>" class="card-img-top" alt="<?php echo htmlspecialchars($article['title']); ?>" style="height: 200px; object-fit: cover;">
                    </a>
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title"><?php echo htmlspecialchars($article['title']); ?></h5>
                        <div class="d-flex justify-content-between text-muted small mb-2">
                            <span>By <?php echo htmlspecialchars($article['author']); ?></span>
                            <span><?php echo date("M d, Y", strtotime($article['publish_date'])); ?></span>
                        </div>
                        <p class="card-text flex-grow-1"><?php echo substr(strip_tags($article['content']), 0, 100); ?>...</p>
                        <a href="article-details.php?id=<?php echo $article['id']; ?>" class="btn btn-primary mt-auto">Read More</a>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        <?php else: ?>
            <p class="text-center">No articles have been published yet.</p>
        <?php endif; ?>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
