<?php
include 'admin-header.php'; // This is the corrected line

// --- DATA FETCHING ---
$search_term = $_GET['search'] ?? '';

// Build the WHERE clause for search
$where_clause = "";
$search_params = [];
$param_types = '';
if (!empty($search_term)) {
    $where_clause = " WHERE (u.full_name LIKE ? OR u.email LIKE ? OR t.reference_number LIKE ? OR t.id = ?)";
    $like_term = "%" . $search_term . "%";
    $search_params = [$like_term, $like_term, $like_term, $search_term];
    $param_types = 'sssi';
}

// Main SQL query to fetch all transactions with user info
$sql = "SELECT t.*, u.full_name, u.email 
        FROM transactions t 
        JOIN users u ON t.user_id = u.id 
        $where_clause 
        ORDER BY t.created_at DESC";

$stmt = $conn->prepare($sql);
if (!empty($search_params)) {
    $stmt->bind_param($param_types, ...$search_params);
}
$stmt->execute();
$result = $stmt->get_result();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Transaction History</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <form method="GET" class="d-flex">
             <input class="form-control me-2" type="search" name="search" placeholder="Search by User, Ref # or ID..." value="<?php echo htmlspecialchars($search_term); ?>" aria-label="Search">
             <button class="btn btn-outline-success" type="submit">Search</button>
        </form>
    </div>
</div>

<div class="card shadow-sm">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Date</th>
                        <th>User</th>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Method / Ref #</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result->num_rows > 0): while($row = $result->fetch_assoc()): 
                        // Determine color and prefix for the amount
                        $isDebit = in_array($row['transaction_type'], ['Booking Payment', 'Admin Debit']);
                        $amount_class = $isDebit ? 'text-danger' : 'text-success';
                        $amount_prefix = $isDebit ? '-' : '+';
                        
                        // Determine badge color for status
                        $status_badge = 'bg-secondary';
                        if ($row['status'] == 'Completed') $status_badge = 'bg-success';
                        if ($row['status'] == 'Pending') $status_badge = 'bg-warning text-dark';
                        if ($row['status'] == 'Rejected') $status_badge = 'bg-danger';
                    ?>
                    <tr>
                        <td><strong>#<?php echo $row['id']; ?></strong></td>
                        <td><?php echo date("M d, Y H:i A", strtotime($row['created_at'])); ?></td>
                        <td><strong><?php echo htmlspecialchars($row['full_name']); ?></strong><br><small class="text-muted"><?php echo htmlspecialchars($row['email']); ?></small></td>
                        <td><?php echo htmlspecialchars($row['transaction_type']); ?></td>
                        <td class="<?php echo $amount_class; ?> fw-bold"><?php echo $amount_prefix; ?> ₱<?php echo number_format($row['amount'], 2); ?></td>
                        <td><?php echo htmlspecialchars($row['payment_method']); ?><br><small class="text-muted"><?php echo htmlspecialchars($row['reference_number']); ?></small></td>
                        <td><span class="badge <?php echo $status_badge; ?>"><?php echo $row['status']; ?></span></td>
                    </tr>
                    <?php endwhile; else: ?>
                        <tr><td colspan="7" class="text-center p-4">No transactions found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'admin-footer.php'; ?>
