<?php
// --- LOGIC BLOCK ---
require_once '../includes/db.php';
if (!isset($_SESSION['admin_logged_in'])) { header("Location: ../login.php"); exit; }

$message = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_settings'])) {
    // --- Handle File Uploads ---
    require_once '../includes/image-resizer.php';
    $logo_url = $_POST['current_logo_url'];
    if (isset($_FILES['site_logo']) && $_FILES['site_logo']['error'] == 0) {
        $target_dir = "../uploads/site/"; if (!is_dir($target_dir)) { @mkdir($target_dir, 0755, true); }
        $target_file = $target_dir . "logo." . strtolower(pathinfo($_FILES["site_logo"]["name"], PATHINFO_EXTENSION));
        if (move_uploaded_file($_FILES["site_logo"]["tmp_name"], $target_file)) { $logo_url = str_replace('../', '', $target_file) . '?v=' . time(); }
    }
    $_POST['settings']['site_logo_url'] = $logo_url;

    if (isset($_FILES['favicon_image']) && $_FILES['favicon_image']['error'] == 0) {
        $tmp_name = $_FILES['favicon_image']['tmp_name'];
        resizeImage($tmp_name, '../favicon-32x32.png', 32, 32);
        resizeImage($tmp_name, '../apple-touch-icon.png', 180, 180);
    }

    $hero_bg_url = $_POST['current_hero_bg_url'];
    if (isset($_FILES['hero_image']) && $_FILES['hero_image']['error'] == 0) {
        $target_dir = "../uploads/site/"; if (!is_dir($target_dir)) { @mkdir($target_dir, 0755, true); }
        $target_file = $target_dir . "hero-background.jpg";
        if (resizeImage($_FILES["hero_image"]["tmp_name"], $target_file, 1920, 1080)) { $hero_bg_url = str_replace('../', '', $target_file) . '?v=' . time(); }
    }
    $_POST['settings']['hero_background_url'] = $hero_bg_url;

    // --- Handle Checkboxes and Save All Settings ---
    $_POST['settings']['paymongo_enabled'] = isset($_POST['settings']['paymongo_enabled']) ? '1' : '0';
    $_POST['settings']['paypal_enabled'] = isset($_POST['settings']['paypal_enabled']) ? '1' : '0';
    $_POST['settings']['paypal_sandbox_mode'] = isset($_POST['settings']['paypal_sandbox_mode']) ? '1' : '0';
    foreach ($_POST['settings'] as $name => $value) {
        $stmt = $conn->prepare("INSERT INTO site_settings (setting_name, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
        $stmt->bind_param("sss", $name, $value, $value);
        $stmt->execute();
    }
    $message = '<div class="alert alert-success">Settings updated successfully!</div>';
}
// Fetch all current settings for the form
$result = $conn->query("SELECT * FROM site_settings");
$settings = [];
while ($row = $result->fetch_assoc()) { $settings[$row['setting_name']] = $row['setting_value']; }
// --- PRESENTATION BLOCK ---
include 'admin-header.php';
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom"><h1 class="h2">Site Settings</h1></div>
<?php echo $message; ?>
<form method="POST" action="site-settings.php" enctype="multipart/form-data">
    <div class="card shadow-sm mb-4"><div class="card-header fw-bold"><i class="bi bi-person-badge-fill me-2"></i>General Site Details</div><div class="card-body"><div class="mb-3"><label class="form-label">Site Name</label><input type="text" class="form-control" name="settings[site_name]" value="<?php echo htmlspecialchars($settings['site_name'] ?? ''); ?>"></div><div class="row"><div class="col-md-6 mb-3"><label class="form-label">Site Logo</label><input type="file" class="form-control" name="site_logo" accept="image/*"><input type="hidden" name="current_logo_url" value="<?php echo htmlspecialchars($settings['site_logo_url'] ?? ''); ?>"><?php if (!empty($settings['site_logo_url'])): ?><div class="mt-2"><img src="../<?php echo htmlspecialchars($settings['site_logo_url']); ?>" style="max-height: 60px; background: #f0f0f0; padding: 5px; border-radius: 5px;"></div><?php endif; ?></div><div class="col-md-6 mb-3"><label class="form-label">Favicon (Browser Tab Icon)</label><input type="file" class="form-control" name="favicon_image" accept="image/png, image/jpeg"><small class="text-muted">Upload a square image (e.g., 512x512).</small></div></div><div class="mb-3"><label class="form-label">Homepage Background Image</label><input type="file" class="form-control" name="hero_image" accept="image/jpeg, image/png"><input type="hidden" name="current_hero_bg_url" value="<?php echo htmlspecialchars($settings['hero_background_url'] ?? ''); ?>"><small class="text-muted">Recommended size: 1920x1080 pixels.</small></div><div class="mb-3"><label class="form-label">Footer Copyright Text</label><textarea class="form-control" name="settings[site_footer_text]"><?php echo htmlspecialchars($settings['site_footer_text'] ?? ''); ?></textarea><small class="form-text text-muted">Use <code>{year}</code> for the current year.</small></div></div></div>
    <div class="card shadow-sm mb-4"><div class="card-header fw-bold"><i class="bi bi-telephone-fill me-2"></i>Contact & Location</div><div class="card-body"><div class="mb-3"><label class="form-label">Contact Email (Public)</label><input type="email" class="form-control" name="settings[contact_email]" value="<?php echo htmlspecialchars($settings['contact_email'] ?? ''); ?>"></div><div class="mb-3"><label class="form-label">Recipient Email (For Notifications)</label><input type="email" class="form-control" name="settings[recipient_email]" value="<?php echo htmlspecialchars($settings['recipient_email'] ?? ''); ?>"></div><div class="mb-3"><label class="form-label">Contact Phone</label><input type="text" class="form-control" name="settings[contact_phone]" value="<?php echo htmlspecialchars($settings['contact_phone'] ?? ''); ?>"></div><div class="mb-3"><label class="form-label">Address</label><textarea class="form-control" name="settings[contact_address]"><?php echo htmlspecialchars($settings['contact_address'] ?? ''); ?></textarea></div><div class="mb-3"><label class="form-label">Google Maps IFrame Code</label><textarea class="form-control" name="settings[google_maps_iframe]" rows="4"><?php echo htmlspecialchars($settings['google_maps_iframe'] ?? ''); ?></textarea></div></div></div>
    <div class="card shadow-sm mb-4"><div class="card-header fw-bold"><i class="bi bi-graph-up-arrow me-2"></i>SEO & Analytics</div><div class="card-body"><div class="mb-3"><label class="form-label">Homepage Meta Description</label><textarea class="form-control" name="settings[seo_meta_description]" rows="3"><?php echo htmlspecialchars($settings['seo_meta_description'] ?? ''); ?></textarea></div><div class="mb-3"><label class="form-label">Homepage Meta Keywords</label><input type="text" class="form-control" name="settings[seo_meta_keywords]" value="<?php echo htmlspecialchars($settings['seo_meta_keywords'] ?? ''); ?>"></div><hr><div class="alert alert-danger"><h5 class="alert-heading"><i class="bi bi-exclamation-triangle-fill"></i> Advanced Users Only</h5><p>Only paste code from trusted services like Google Analytics.</p></div><div class="mb-3"><label class="form-label">Header Scripts</label><textarea class="form-control font-monospace" name="settings[header_scripts]" rows="5" placeholder="Paste code here..."><?php echo htmlspecialchars($settings['header_scripts'] ?? ''); ?></textarea></div><div class="mb-3"><label class="form-label">Footer Scripts</label><textarea class="form-control font-monospace" name="settings[footer_scripts]" rows="5" placeholder="Paste code here..."><?php echo htmlspecialchars($settings['footer_scripts'] ?? ''); ?></textarea></div></div></div>
    <div class="card shadow-sm mb-4"><div class="card-header fw-bold"><i class="bi bi-credit-card-2-front-fill me-2"></i>Payment Gateways</div><div class="card-body"><h5 class="card-title">PayMongo (GCash, Maya, etc.)</h5><div class="form-check form-switch mb-3"><input class="form-check-input" type="checkbox" role="switch" id="paymongo_enabled" name="settings[paymongo_enabled]" value="1" <?php echo ($settings['paymongo_enabled'] ?? 0) == 1 ? 'checked' : ''; ?>><label class="form-check-label" for="paymongo_enabled">Enable PayMongo</label></div><div class="mb-3"><label class="form-label">PayMongo Public Key</label><input type="text" class="form-control" name="settings[paymongo_public_key]" value="<?php echo htmlspecialchars($settings['paymongo_public_key'] ?? ''); ?>"></div><div class="mb-3"><label class="form-label">PayMongo Secret Key</label><input type="password" class="form-control" name="settings[paymongo_secret_key]" value="<?php echo htmlspecialchars($settings['paymongo_secret_key'] ?? ''); ?>"></div><hr><h5 class="card-title mt-4">PayPal</h5><div class="form-check form-switch mb-3"><input class="form-check-input" type="checkbox" role="switch" id="paypal_enabled" name="settings[paypal_enabled]" value="1" <?php echo ($settings['paypal_enabled'] ?? 0) == 1 ? 'checked' : ''; ?>><label class="form-check-label" for="paypal_enabled">Enable PayPal</label></div><div class="mb-3"><label class="form-label">PayPal Client ID</label><input type="text" class="form-control" name="settings[paypal_client_id]" value="<?php echo htmlspecialchars($settings['paypal_client_id'] ?? ''); ?>"></div></div></div>
    <div class="card shadow-sm mb-4"><div class="card-header fw-bold"><i class="bi bi-robot me-2"></i>API & Integration</div><div class="card-body"><div class="mb-3"><label class="form-label">TinyMCE API Key</label><input type="password" class="form-control" name="settings[tinymce_api_key]" value="<?php echo htmlspecialchars($settings['tinymce_api_key'] ?? ''); ?>"><small class="form-text text-muted">Your free API key from tiny.cloud for the text editor.</small></div></div></div>
    <button type="submit" name="save_settings" class="btn btn-primary btn-lg">Save All Settings</button>
</form>
<?php include 'admin-footer.php'; ?>
