<?php
include 'admin-header.php';
$message = '';
// ACTION HANDLING
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['delete_port'])) {
        $id = intval($_POST['id']);
        $stmt = $conn->prepare("DELETE FROM ferry_ports WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $message = '<div class="alert alert-success">Ferry port deleted successfully.</div>';
    } elseif (isset($_POST['save_port'])) {
        $id = intval($_POST['id'] ?? 0);
        $name = trim($_POST['port_name']);
        $city = trim($_POST['city']);
        if ($id > 0) {
            $stmt = $conn->prepare("UPDATE ferry_ports SET port_name=?, city=? WHERE id=?");
            $stmt->bind_param("ssi", $name, $city, $id);
            $message = '<div class="alert alert-success">Ferry port updated.</div>';
        } else {
            $stmt = $conn->prepare("INSERT INTO ferry_ports (port_name, city) VALUES (?, ?)");
            $stmt->bind_param("ss", $name, $city);
            $message = '<div class="alert alert-success">New ferry port added.</div>';
        }
        $stmt->execute();
    }
}
$edit_port = null;
if (isset($_GET['edit'])) {
    $stmt = $conn->prepare("SELECT * FROM ferry_ports WHERE id = ?");
    $stmt->bind_param("i", $_GET['edit']);
    $stmt->execute();
    $edit_port = $stmt->get_result()->fetch_assoc();
}
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Manage Ferry Ports</h1>
</div>
<?php echo $message; ?>
<div class="card shadow-sm mb-4">
    <div class="card-header"><?php echo $edit_port ? 'Edit Ferry Port' : 'Add New Ferry Port'; ?></div>
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="id" value="<?php echo $edit_port['id'] ?? 0; ?>">
            <div class="row">
                <div class="col-md-6"><label>Port Name</label><input type="text" name="port_name" class="form-control" value="<?php echo htmlspecialchars($edit_port['port_name'] ?? ''); ?>" required></div>
                <div class="col-md-6"><label>City / Location</label><input type="text" name="city" class="form-control" value="<?php echo htmlspecialchars($edit_port['city'] ?? ''); ?>" required></div>
            </div>
            <button type="submit" name="save_port" class="btn btn-primary mt-3"><?php echo $edit_port ? 'Save Changes' : 'Add Port'; ?></button>
        </form>
    </div>
</div>
<div class="card shadow-sm"><div class="card-header">Existing Ferry Ports</div><div class="table-responsive">
    <table class="table table-hover">
        <thead><tr><th>Port Name</th><th>City / Location</th><th>Actions</th></tr></thead>
        <tbody>
        <?php $result = $conn->query("SELECT * FROM ferry_ports ORDER BY city ASC"); while ($row = $result->fetch_assoc()): ?>
            <tr>
                <td><?php echo htmlspecialchars($row['port_name']); ?></td>
                <td><?php echo htmlspecialchars($row['city']); ?></td>
                <td><a href="?edit=<?php echo $row['id']; ?>" class="btn btn-sm btn-primary">Edit</a></td>
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
</div></div>
<?php include 'admin-footer.php'; ?>
