<?php
include 'admin-header.php';

$message = '';
// --- ACTION HANDLING ---
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // --- DELETE FAQ ---
    if (isset($_POST['delete_faq'])) {
        $id_to_delete = intval($_POST['id']);
        $stmt = $conn->prepare("DELETE FROM faqs WHERE id = ?");
        $stmt->bind_param("i", $id_to_delete);
        $stmt->execute();
        $message = '<div class="alert alert-success">FAQ deleted successfully.</div>';
    } 
    // --- SAVE (ADD/EDIT) FAQ ---
    elseif (isset($_POST['save_faq'])) {
        $id = intval($_POST['id'] ?? 0);
        $question = trim($_POST['question']);
        $answer = trim($_POST['answer']);
        $display_order = intval($_POST['display_order']);
        $is_visible = isset($_POST['is_visible']) ? 1 : 0;

        if ($id > 0) { // Update
            $stmt = $conn->prepare("UPDATE faqs SET question=?, answer=?, display_order=?, is_visible=? WHERE id=?");
            $stmt->bind_param("ssiii", $question, $answer, $display_order, $is_visible, $id);
            $message = '<div class="alert alert-success">FAQ updated successfully.</div>';
        } else { // Insert
            $stmt = $conn->prepare("INSERT INTO faqs (question, answer, display_order, is_visible) VALUES (?, ?, ?, ?)");
            $stmt->bind_param("ssii", $question, $answer, $display_order, $is_visible);
            $message = '<div class="alert alert-success">New FAQ added successfully.</div>';
        }
        $stmt->execute();
        $stmt->close();
    }
}

// Fetch FAQ for editing if an ID is provided
$edit_faq = null;
if (isset($_GET['edit'])) {
    $stmt = $conn->prepare("SELECT * FROM faqs WHERE id = ?");
    $stmt->bind_param("i", $_GET['edit']);
    $stmt->execute();
    $edit_faq = $stmt->get_result()->fetch_assoc();
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Manage FAQs</h1>
</div>
<?php echo $message; ?>

<div class="card shadow-sm mb-4">
    <div class="card-header"><?php echo $edit_faq ? 'Edit FAQ' : 'Add New FAQ'; ?></div>
    <div class="card-body">
        <form method="POST">
            <input type="hidden" name="id" value="<?php echo $edit_faq['id'] ?? 0; ?>">
            <div class="mb-3"><label>Question</label><input type="text" class="form-control" name="question" value="<?php echo htmlspecialchars($edit_faq['question'] ?? ''); ?>" required></div>
            <div class="mb-3"><label>Answer</label><textarea class="form-control" name="answer" rows="4" required><?php echo htmlspecialchars($edit_faq['answer'] ?? ''); ?></textarea></div>
            <div class="row">
                <div class="col-md-6 mb-3"><label>Display Order</label><input type="number" class="form-control" name="display_order" value="<?php echo $edit_faq['display_order'] ?? 0; ?>"></div>
                <div class="col-md-6 mb-3 d-flex align-items-end">
                    <div class="form-check form-switch"><input type="checkbox" class="form-check-input" id="is_visible" name="is_visible" value="1" <?php echo (isset($edit_faq['is_visible']) && $edit_faq['is_visible']) || !$edit_faq ? 'checked' : ''; ?>><label class="form-check-label" for="is_visible">Visible on Website</label></div>
                </div>
            </div>
            <button type="submit" name="save_faq" class="btn btn-primary"><?php echo $edit_faq ? 'Save Changes' : 'Add FAQ'; ?></button>
            <?php if ($edit_faq): ?><a href="manage-faqs.php" class="btn btn-secondary">Cancel Edit</a><?php endif; ?>
        </form>
    </div>
</div>

<div class="card shadow-sm">
    <div class="card-header">Existing FAQs</div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead class="table-dark"><tr><th>Order</th><th>Question</th><th>Status</th><th>Actions</th></tr></thead>
                <tbody>
                <?php $result = $conn->query("SELECT * FROM faqs ORDER BY display_order ASC"); while ($faq = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?php echo $faq['display_order']; ?></td>
                        <td><?php echo htmlspecialchars($faq['question']); ?></td>
                        <td><?php echo $faq['is_visible'] ? '<span class="badge bg-success">Visible</span>' : '<span class="badge bg-secondary">Hidden</span>'; ?></td>
                        <td>
                            <a href="?edit=<?php echo $faq['id']; ?>" class="btn btn-sm btn-primary">Edit</a>
                            <form method="POST" class="d-inline" onsubmit="return confirm('Are you sure?');"><input type="hidden" name="id" value="<?php echo $faq['id']; ?>"><button type="submit" name="delete_faq" class="btn btn-sm btn-danger">Delete</button></form>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'admin-footer.php'; ?>
