function activateAutocomplete(inputId, type) {
    const input = document.getElementById(inputId);
    if (!input) return;

    const container = input.parentNode;
    const suggestions = document.createElement('div');
    suggestions.className = 'autocomplete-suggestions';
    container.appendChild(suggestions);

    input.addEventListener('input', function() {
        const term = this.value;
        if (term.length < 2) {
            suggestions.innerHTML = '';
            return;
        }

        fetch(`autocomplete-search.php?term=${encodeURIComponent(term)}&type=${type}`)
            .then(response => response.json())
            .then(data => {
                suggestions.innerHTML = '';
                data.forEach(item => {
                    const div = document.createElement('div');
                    div.innerHTML = item.replace(new RegExp(term, 'gi'), '<strong>$&</strong>');
                    div.addEventListener('click', function() {
                        input.value = item;
                        suggestions.innerHTML = '';
                    });
                    suggestions.appendChild(div);
                });
            });
    });

    // Hide suggestions when clicking elsewhere
    document.addEventListener('click', function(e) {
        if (e.target !== input) {
            suggestions.innerHTML = '';
        }
    });
}
