<?php
// The header now handles security and fetches the initial $admin_user data
include 'admin-header.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // --- Update Profile Details ---
    if (isset($_POST['update_details'])) {
        $full_name = trim($_POST['full_name']);
        $email = trim($_POST['email']);
        
        $stmt = $conn->prepare("UPDATE users SET full_name = ?, email = ? WHERE id = ?");
        $stmt->bind_param("ssi", $full_name, $email, $admin_id);
        if ($stmt->execute()) {
            $_SESSION['user_name'] = $full_name; // Update session name
            $message = '<div class="alert alert-success">Profile details updated successfully.</div>';
        } else {
            $message = '<div class="alert alert-danger">Error updating details. The email may already be in use by another account.</div>';
        }
    }

    // --- Change Password ---
    if (isset($_POST['change_password'])) {
        $current_password = $_POST['current_password'];
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];

        // We re-fetch the user here to get the most current password hash for verification
        $current_user_data = $conn->query("SELECT password FROM users WHERE id = $admin_id")->fetch_assoc();

        if (password_verify($current_password, $current_user_data['password'])) {
            if (strlen($new_password) < 8) {
                $message = '<div class="alert alert-danger">New password must be at least 8 characters long.</div>';
            } elseif ($new_password !== $confirm_password) {
                $message = '<div class="alert alert-danger">New passwords do not match.</div>';
            } else {
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                $stmt_pass = $conn->prepare("UPDATE users SET password = ? WHERE id = ?");
                $stmt_pass->bind_param("si", $hashed_password, $admin_id);
                $stmt_pass->execute();
                $message = '<div class="alert alert-success">Password changed successfully.</div>';
            }
        } else {
            $message = '<div class="alert alert-danger">Your Current Password was incorrect.</div>';
        }
    }
    // Re-fetch data after any potential update to show the latest info
    $admin_user = $conn->query("SELECT * FROM users WHERE id = $admin_id")->fetch_assoc();
}
?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Edit My Profile</h1>
</div>
<?php echo $message; ?>

<div class="row">
    <div class="col-lg-6">
        <div class="card shadow-sm mb-4">
            <div class="card-header">My Details</div>
            <div class="card-body">
                <form method="POST">
                    <div class="mb-3"><label>Full Name</label><input type="text" name="full_name" class="form-control" value="<?php echo htmlspecialchars($admin_user['full_name']); ?>" required></div>
                    <div class="mb-3"><label>Email Address</label><input type="email" name="email" class="form-control" value="<?php echo htmlspecialchars($admin_user['email']); ?>" required></div>
                    <button type="submit" name="update_details" class="btn btn-primary">Save Details</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-6">
        <div class="card shadow-sm mb-4">
            <div class="card-header">Change Password</div>
            <div class="card-body">
                <form method="POST">
                    <div class="mb-3"><label>Current Password</label><input type="password" name="current_password" class="form-control" required></div>
                    <div class="mb-3"><label>New Password</label><input type="password" name="new_password" class="form-control" required></div>
                    <div class="mb-3"><label>Confirm New Password</label><input type="password" name="confirm_password" class="form-control" required></div>
                    <button type="submit" name="change_password" class="btn btn-primary">Change Password</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php include 'admin-footer.php'; ?>
