        </main>
    </div>
</div>

<div class="toast-container position-fixed bottom-0 end-0 p-3" style="z-index: 1100">
    </div>

<audio id="notificationSound" src="/assets/notification.mp3" preload="auto"></audio>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    
    // --- Realtime Pop-up Notification Logic ---
    const toastContainer = document.querySelector('.toast-container');
    const notificationSound = document.getElementById('notificationSound');

    function createToast(notification) {
        const toastEl = document.createElement('div');
        toastEl.className = 'toast';
        toastEl.setAttribute('role', 'alert');
        toastEl.setAttribute('aria-live', 'assertive');
        toastEl.setAttribute('aria-atomic', 'true');

        let icon = 'bi-info-circle-fill';
        if (notification.type.includes('Partner')) icon = 'bi-person-plus-fill';
        if (notification.type.includes('Top-Up')) icon = 'bi-arrow-up-circle-fill';
        if (notification.type.includes('Withdrawal')) icon = 'bi-cash-coin';
        if (notification.type.includes('Document')) icon = 'bi-file-earmark-check-fill';
        if (notification.type.includes('Message')) icon = 'bi-envelope-fill';

        toastEl.innerHTML = `
            <div class="toast-header">
                <i class="bi ${icon} rounded me-2"></i>
                <strong class="me-auto">${notification.type}</strong>
                <small>Just now</small>
                <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body">
                New request from <strong>${escapeHtml(notification.detail)}</strong>.
            </div>
        `;
        
        toastContainer.appendChild(toastEl);
        const toast = new bootstrap.Toast(toastEl);
        toast.show();

        if (notificationSound) {
            notificationSound.currentTime = 0;
            notificationSound.play().catch(error => {
                console.warn("Notification sound was blocked by the browser. User must interact with the page first.");
            });
        }
    }

    function escapeHtml(unsafe) {
        return unsafe.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&#039;");
    }

    function checkAdminNotifications() {
        fetch(`check-admin-notifications.php`)
            .then(response => response.json())
            .then(data => {
                if (data.success && data.notifications.length > 0) {
                    data.notifications.forEach(notification => createToast(notification));
                }
            })
            .catch(error => console.error('Error checking for notifications:', error));
    }

    // Check for new notifications every 10 seconds
    setInterval(checkAdminNotifications, 10000);
});
</script>

</body>
</html>
