<?php
// This script generates a sample PDF for preview purposes only.
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once '../includes/db.php';
require_once '../vendor/dompdf/autoload.inc.php';
require_once '../includes/qrcode/qrlib.php';
require_once '../includes/helpers.php'; // Includes currency and design helpers

use Dompdf\Dompdf;
use Dompdf\Options;

// Security: Admin must be logged in to view a preview
if (!isset($_SESSION['admin_logged_in'])) { die("Access Denied."); }

$type = $_GET['type'] ?? '';
// Validate the 'type' parameter
if (!in_array($type, ['tour', 'hotel', 'flight', 'ferry'])) { 
    die("Invalid preview type specified. Please go back and try again."); 
}

// Fetch all site settings for branding and design
$settings_result = $conn->query("SELECT * FROM site_settings");
$site_settings = [];
while ($row = $settings_result->fetch_assoc()) { $site_settings[$row['setting_name']] = $row['setting_value']; }

// Prepare currency variables for the template
$rates = get_exchange_rates($conn, $site_settings);
$current_currency = $_SESSION['currency'] ?? $site_settings['site_base_currency'] ?? 'PHP';

// --- GENERATE REALISTIC SAMPLE DATA ---
$booking = [];
$template_file = '';
$qr_data = 'PREVIEW-ONLY-https://' . $_SERVER['HTTP_HOST'];

switch ($type) {
    case 'tour':
        $booking = [
            'id' => 'SAMPLE-123', 'customer_name' => 'Juan Dela Cruz',
            'tour_title' => 'Sample: Coron Ultimate Tour', 'location' => 'Coron, Palawan',
            'booking_date' => date('Y-m-d', strtotime('+14 days')), 'num_travelers' => 2, 'total_price' => '3700.00'
        ];
        $template_file = '../templates/ticket-tour.php';
        break;
    case 'hotel':
        $booking = [
            'id' => 'SAMPLE-456', 'full_name' => 'Maria Santos',
            'hotel_name' => 'Sample: Shangri-La Mactan', 'location' => 'Cebu', 'room_type_name' => 'Deluxe Sea View',
            'check_in_date' => date('Y-m-d', strtotime('+21 days')), 'check_out_date' => date('Y-m-d', strtotime('+24 days')),
            'num_guests' => 2, 'total_price' => '37500.00'
        ];
        $template_file = '../templates/ticket-hotel.php';
        break;
    case 'flight':
        $booking = [
            'id' => 'SAMPLE-789', 'full_name' => 'Javier Garcia',
            'origin_city' => 'Manila', 'dest_city' => 'Tokyo',
            'departure_date' => date('Y-m-d', strtotime('+30 days')), 'return_date' => date('Y-m-d', strtotime('+40 days')),
            'total_price' => '25000.00', 'admin_notes' => "Airline: Philippine Airlines\nFlight: PR 432\nMNL-NRT 08:00-13:30"
        ];
        $template_file = '../templates/ticket-flight.php';
        break;
    case 'ferry':
        $booking = [
            'id' => 'SAMPLE-101', 'full_name' => 'Althea Reyes',
            'origin_city' => 'Batangas', 'dest_city' => 'Caticlan (Boracay)',
            'ferry_company' => '2GO Travel', 'departure_date' => date('Y-m-d', strtotime('+18 days')),
            'num_passengers' => 4, 'total_price' => '4800.00'
        ];
        $template_file = '../templates/ticket-ferry.php';
        break;
}

// --- GENERATE QR CODE ---
ob_start();
QRCode::png($qr_data, null, QR_ECLEVEL_L, 3);
$qr_image_data = ob_get_contents();
ob_end_clean();
$qr_code_path = 'data:image/png;base64,' . base64_encode($qr_image_data);

// --- GENERATE PDF ---
ob_start();
// The include() function requires a valid file path.
// If $template_file is empty, it will cause the 'Path cannot be empty' error.
// The check at the top of the script prevents this.
include $template_file;
$html = ob_get_clean();

$options = new Options();
$options->set('isRemoteEnabled', true);
$options->setChroot($_SERVER['DOCUMENT_ROOT']);
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("PREVIEW-Ticket-".$type.".pdf", ["Attachment" => false]);
?>
