<?php
include 'admin-header.php';

$message = '';
// Handle form submission to save theme colors
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_theme'])) {
    $theme_colors = $_POST['settings'];
    foreach ($theme_colors as $name => $value) {
        $stmt = $conn->prepare("UPDATE site_settings SET setting_value = ? WHERE setting_name = ?");
        $stmt->bind_param("ss", $value, $name);
        $stmt->execute();
    }
    $message = '<div class="alert alert-success">Theme settings have been updated successfully!</div>';
    // Re-fetch settings to show the new values
    $settings_result = $conn->query("SELECT * FROM site_settings");
    $settings = [];
    while ($row = $settings_result->fetch_assoc()) { $settings[$row['setting_name']] = $row['setting_value']; }
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Theme & Color Editor</h1>
</div>
<?php echo $message; ?>

<div class="card shadow-sm">
    <div class="card-header">Customize Your Website's Colors</div>
    <div class="card-body">
        <p>Use the color pickers below to change the look and feel of your public-facing website. The changes will apply to buttons, links, backgrounds, and the navigation bar.</p>
        <form method="POST">
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label class="form-label">Primary Color</label>
                    <input type="color" class="form-control form-control-color" name="settings[theme_primary_color]" value="<?php echo htmlspecialchars($settings['theme_primary_color'] ?? '#0d6efd'); ?>">
                    <small class="text-muted">Main brand color for buttons, links, and accents.</small>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Secondary Color</label>
                    <input type="color" class="form-control form-control-color" name="settings[theme_secondary_color]" value="<?php echo htmlspecialchars($settings['theme_secondary_color'] ?? '#6c757d'); ?>">
                    <small class="text-muted">Used for less important buttons and accents.</small>
                </div>
                 <div class="col-md-4 mb-3">
                    <label class="form-label">Success Color</label>
                    <input type="color" class="form-control form-control-color" name="settings[theme_success_color]" value="<?php echo htmlspecialchars($settings['theme_success_color'] ?? '#198754'); ?>">
                    <small class="text-muted">Used for "Book Now" buttons and positive feedback.</small>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Dark Color</label>
                    <input type="color" class="form-control form-control-color" name="settings[theme_dark_color]" value="<?php echo htmlspecialchars($settings['theme_dark_color'] ?? '#212529'); ?>">
                    <small class="text-muted">Used for the main navigation bar and footer.</small>
                </div>
                 <div class="col-md-4 mb-3">
                    <label class="form-label">Light Color</label>
                    <input type="color" class="form-control form-control-color" name="settings[theme_light_color]" value="<?php echo htmlspecialchars($settings['theme_light_color'] ?? '#f8f9fa'); ?>">
                    <small class="text-muted">Used for section backgrounds like the reviews area.</small>
                </div>
            </div>
            <button type="submit" name="save_theme" class="btn btn-primary mt-3">Save Theme</button>
        </form>
    </div>
</div>
<?php include 'admin-footer.php'; ?>
