<?php
require_once 'admin-header.php';
$page_title = 'Manage Response Templates';

// --- CRUD Logic for Templates ---
$action = $_POST['action'] ?? '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($action === 'save_template') {
        $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
        $title = trim($_POST['title']);
        $body = trim($_POST['body']);

        if ($id) { // Update
            $stmt = $conn->prepare("UPDATE support_templates SET title = ?, body = ? WHERE id = ?");
            $stmt->bind_param("ssi", $title, $body, $id);
            $_SESSION['success_message'] = "Template updated successfully.";
        } else { // Create
            $stmt = $conn->prepare("INSERT INTO support_templates (title, body) VALUES (?, ?)");
            $stmt->bind_param("ss", $title, $body);
            $_SESSION['success_message'] = "Template created successfully.";
        }
        $stmt->execute();
        $stmt->close();
    } elseif ($action === 'delete_template') {
        $id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
        $stmt = $conn->prepare("DELETE FROM support_templates WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $stmt->close();
        $_SESSION['success_message'] = "Template deleted successfully.";
    }
    header("Location: manage-templates.php");
    exit();
}

// Fetch all templates
$templates = $conn->query("SELECT * FROM support_templates ORDER BY title ASC")->fetch_all(MYSQLI_ASSOC);
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-lightning-charge-fill me-2"></i>Manage Response Templates</h1>
</div>

<?php if (isset($_SESSION['success_message'])): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert"><?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
<?php endif; ?>

<div class="row">
    <div class="col-lg-4 mb-4">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light border-0"><h5 class="mb-0">Add New Template</h5></div>
            <div class="card-body">
                <form method="POST">
                    <input type="hidden" name="action" value="save_template">
                    <div class="mb-3"><label for="title" class="form-label">Template Title</label><input type="text" class="form-control" id="title" name="title" required></div>
                    <div class="mb-3"><label for="body" class="form-label">Template Body</label><textarea class="form-control" id="body" name="body" rows="5" required></textarea></div>
                    <button type="submit" class="btn btn-primary">Save Template</button>
                </form>
            </div>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="card shadow-sm border-0">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead><tr><th>Title</th><th>Actions</th></tr></thead>
                        <tbody>
                            <?php foreach ($templates as $template): ?>
                            <tr>
                                <td class="fw-bold"><?php echo htmlspecialchars($template['title']); ?></td>
                                <td>
                                    <form method="POST" onsubmit="return confirm('Are you sure?');" class="d-inline">
                                        <input type="hidden" name="action" value="delete_template">
                                        <input type="hidden" name="id" value="<?php echo $template['id']; ?>">
                                        <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'admin-footer.php'; ?>
