<?php
require_once 'admin-header.php'; 
$page_title = 'Manage Customer Reviews';

// --- Handle Approve/Delete Actions ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $review_id = filter_input(INPUT_POST, 'review_id', FILTER_VALIDATE_INT);
    $action = $_POST['action'] ?? '';

    if ($action === 'approve' && $review_id) {
        $stmt = $conn->prepare("UPDATE user_reviews SET is_approved = 1 WHERE id = ?");
        $stmt->bind_param("i", $review_id);
        $stmt->execute();
        $_SESSION['success_message'] = "Review approved and is now live.";
    } 
    elseif ($action === 'delete' && $review_id) {
        $stmt = $conn->prepare("DELETE FROM user_reviews WHERE id = ?");
        $stmt->bind_param("i", $review_id);
        $stmt->execute();
        $_SESSION['success_message'] = "Review has been deleted.";
    }
    header("Location: manage-reviews.php");
    exit();
}

// --- Fetch Reviews ---
$filter_status = $_GET['status'] ?? 'pending';
$where_sql = "WHERE ur.is_approved = " . ($filter_status === 'approved' ? '1' : '0');

$stmt = $conn->prepare("
    SELECT ur.id, ur.rating, ur.review_text, ur.created_at, ur.is_approved,
           u.full_name,
           t.title AS item_title
    FROM user_reviews ur
    JOIN users u ON ur.user_id = u.id
    LEFT JOIN tours t ON ur.item_id = t.id AND ur.item_type = 'tour'
    -- You can add another LEFT JOIN for hotels here if needed
    $where_sql
    ORDER BY ur.created_at DESC
");
$stmt->execute();
$reviews = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-star-half me-2"></i>Manage Customer Reviews</h1>
</div>

<?php if (isset($_SESSION['success_message'])): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert"><?php echo $_SESSION['success_message']; unset($_SESSION['success_message']); ?><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>
<?php endif; ?>

<div class="card shadow-sm border-0">
    <div class="card-header bg-light border-0">
        <form method="GET" class="d-flex align-items-center">
            <label for="status" class="form-label me-2 mb-0">Status:</label>
            <select name="status" id="status" class="form-select w-auto" onchange="this.form.submit()">
                <option value="pending" <?php if($filter_status == 'pending') echo 'selected'; ?>>Pending Approval</option>
                <option value="approved" <?php if($filter_status == 'approved') echo 'selected'; ?>>Approved</option>
            </select>
        </form>
    </div>
    <div class="card-body">
        <?php if (empty($reviews)): ?>
            <div class="text-center p-5">
                <i class="bi bi-journal-check fs-2 text-muted"></i>
                <p class="mt-2 mb-0 text-muted">No <?php echo htmlspecialchars($filter_status); ?> reviews found.</p>
            </div>
        <?php else: ?>
            <?php foreach ($reviews as $review): ?>
            <div class="d-flex align-items-start p-3 border-bottom">
                <div class="flex-grow-1">
                    <div class="d-flex justify-content-between">
                        <div>
                            <strong class="d-block"><?php echo htmlspecialchars($review['full_name']); ?></strong>
                            <small class="text-muted">Reviewed "<?php echo htmlspecialchars($review['item_title']); ?>"</small>
                        </div>
                        <div class="text-warning">
                            <?php for($i=0; $i<$review['rating']; $i++) echo '<i class="bi bi-star-fill"></i>'; ?>
                        </div>
                    </div>
                    <p class="mt-2 mb-2 fst-italic">"<?php echo htmlspecialchars($review['review_text']); ?>"</p>
                    <div class="d-flex align-items-center gap-2">
                        <?php if (!$review['is_approved']): ?>
                            <form method="POST" class="d-inline"><input type="hidden" name="action" value="approve"><input type="hidden" name="review_id" value="<?php echo $review['id']; ?>"><button type="submit" class="btn btn-sm btn-success"><i class="bi bi-check-lg"></i> Approve</button></form>
                        <?php endif; ?>
                        <form method="POST" onsubmit="return confirm('Are you sure?');" class="d-inline"><input type="hidden" name="action" value="delete"><input type="hidden" name="review_id" value="<?php echo $review['id']; ?>"><button type="submit" class="btn btn-sm btn-outline-danger"><i class="bi bi-trash"></i> Delete</button></form>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<?php require_once 'admin-footer.php'; ?>
