<?php
require_once 'admin-header.php'; 
$page_title = 'Manage Hotel Bookings';

// --- Get filter status ---
$filter_status = $_GET['status'] ?? 'Pending Confirmation'; // Default to pending

// --- Build Query ---
$where_sql = '';
if (!empty($filter_status)) {
    $where_sql = "WHERE b.status = '" . $conn->real_escape_string($filter_status) . "'";
}

// --- Fetch Bookings ---
$bookings = $conn->query("
    SELECT b.id, b.booking_ref, b.check_in_date, b.check_out_date, b.status,
           u.full_name as customer_name,
           h.name as hotel_name
    FROM hotel_bookings b
    JOIN users u ON b.user_id = u.id
    JOIN hotels h ON b.hotel_id = h.id
    $where_sql
    ORDER BY b.created_at DESC
")->fetch_all(MYSQLI_ASSOC);
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-building me-2"></i>Manage Hotel Bookings</h1>
</div>

<div class="card shadow-sm border-0">
    <div class="card-header bg-light border-0">
        <form method="GET" class="d-flex align-items-center">
            <label for="status" class="form-label me-2 mb-0">Status:</label>
            <select name="status" id="status" class="form-select w-auto" onchange="this.form.submit()">
                <option value="Pending Confirmation" <?php if($filter_status == 'Pending Confirmation') echo 'selected'; ?>>Pending Confirmation</option>
                <option value="Confirmed" <?php if($filter_status == 'Confirmed') echo 'selected'; ?>>Confirmed</option>
                <option value="Completed" <?php if($filter_status == 'Completed') echo 'selected'; ?>>Completed</option>
                <option value="Cancelled" <?php if($filter_status == 'Cancelled') echo 'selected'; ?>>Cancelled</option>
                <option value="">All</option>
            </select>
        </form>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr><th>Ref #</th><th>Customer</th><th>Hotel</th><th>Dates</th><th class="text-center">Status</th><th class="text-end">Actions</th></tr>
                </thead>
                <tbody>
                    <?php if (empty($bookings)): ?>
                        <tr><td colspan="6" class="text-center p-5 text-muted">No bookings found with this status.</td></tr>
                    <?php else: ?>
                        <?php foreach ($bookings as $booking): ?>
                        <tr>
                            <td class="fw-bold"><?php echo htmlspecialchars($booking['booking_ref']); ?></td>
                            <td><?php echo htmlspecialchars($booking['customer_name']); ?></td>
                            <td><?php echo htmlspecialchars($booking['hotel_name']); ?></td>
                            <td><?php echo date('M d, Y', strtotime($booking['check_in_date'])); ?> - <?php echo date('M d, Y', strtotime($booking['check_out_date'])); ?></td>
                            <td class="text-center"><span class="badge bg-secondary"><?php echo htmlspecialchars($booking['status']); ?></span></td>
                            <td class="text-end"><a href="edit-hotel-booking.php?id=<?php echo $booking['id']; ?>" class="btn btn-sm btn-primary">Manage</a></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php require_once 'admin-footer.php'; ?>
