<?php
require_once 'admin-header.php'; 

$booking_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$booking_id) { header('Location: hotel-bookings.php'); exit(); }

// --- Handle Form Submission ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $total_price = filter_input(INPUT_POST, 'total_price', FILTER_VALIDATE_FLOAT);
    $admin_notes = trim($_POST['admin_notes']);
    
    if ($total_price > 0) {
        $stmt = $conn->prepare("UPDATE hotel_bookings SET total_price = ?, admin_notes = ?, status = 'Confirmed' WHERE id = ?");
        $stmt->bind_param("dsi", $total_price, $admin_notes, $booking_id);
        $stmt->execute();

        // You would add an email notification to the user here
        $_SESSION['success_message'] = "Quote sent successfully. The booking is now confirmed and awaiting payment.";
        header('Location: hotel-bookings.php');
        exit();
    }
}

// --- Fetch Booking Details ---
$stmt = $conn->prepare("
    SELECT b.*, u.full_name as customer_name, h.name as hotel_name
    FROM hotel_bookings b
    JOIN users u ON b.user_id = u.id
    JOIN hotels h ON b.hotel_id = h.id
    WHERE b.id = ?
");
$stmt->bind_param("i", $booking_id);
$stmt->execute();
$booking = $stmt->get_result()->fetch_assoc();
$stmt->close();
if (!$booking) { header('Location: hotel-bookings.php'); exit(); }

$page_title = 'Manage Booking: ' . htmlspecialchars($booking['booking_ref']);
?>

<div class="d-flex justify-content-between align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Manage Hotel Booking</h1>
    <a href="hotel-bookings.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Back to List</a>
</div>

<div class="row">
    <div class="col-lg-7">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-light border-0"><h5>Booking Request Details</h5></div>
            <div class="card-body">
                <p><strong>Reference:</strong> <?php echo htmlspecialchars($booking['booking_ref']); ?></p>
                <p><strong>Customer:</strong> <?php echo htmlspecialchars($booking['customer_name']); ?></p>
                <p><strong>Hotel:</strong> <?php echo htmlspecialchars($booking['hotel_name']); ?></p>
                <p><strong>Check-in:</strong> <?php echo date('F j, Y', strtotime($booking['check_in_date'])); ?></p>
                <p><strong>Check-out:</strong> <?php echo date('F j, Y', strtotime($booking['check_out_date'])); ?></p>
                <p><strong>Guests:</strong> <?php echo htmlspecialchars($booking['num_guests']); ?></p>
                <hr>
                <p><strong>Customer Notes:</strong></p>
                <p class="fst-italic bg-light p-2 rounded"><?php echo nl2br(htmlspecialchars($booking['notes'] ?? 'No notes provided.')); ?></p>
            </div>
        </div>
    </div>

    <div class="col-lg-5">
         <div class="card shadow-sm border-0">
            <div class="card-header bg-light border-0"><h5>Provide Quote</h5></div>
            <div class="card-body">
                <form method="POST">
                    <div class="mb-3">
                        <label for="total_price" class="form-label">Total Price</label>
                        <div class="input-group">
                            <span class="input-group-text">₱</span>
                            <input type="number" step="0.01" class="form-control" name="total_price" id="total_price" value="<?php echo htmlspecialchars($booking['total_price'] ?? ''); ?>" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="admin_notes" class="form-label">Notes for Customer (Optional)</label>
                        <textarea class="form-control" name="admin_notes" id="admin_notes" rows="4" placeholder="e.g., Includes breakfast. Non-refundable."><?php echo htmlspecialchars($booking['admin_notes'] ?? ''); ?></textarea>
                    </div>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">Save and Send Quote</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php require_once 'admin-footer.php'; ?>
