<?php
// This is the central logic file for the entire admin panel.

// 1. Start Session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 2. Security Check: Redirect if not logged in as an admin
if (!isset($_SESSION['admin_id']) || !isset($_SESSION['admin_role']) || $_SESSION['admin_role'] !== 'admin') {
    header('Location: login.php');
    exit();
}
$admin_id = $_SESSION['admin_id'];

// 3. Include Core Files
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';

// 4. Fetch Global Data
$stmt_admin = $conn->prepare("SELECT * FROM admins WHERE id = ?");
$stmt_admin->bind_param("i", $admin_id);
$stmt_admin->execute();
$admin_user = $stmt_admin->get_result()->fetch_assoc();
$stmt_admin->close();

if (!$admin_user) {
    session_destroy();
    header('Location: login.php');
    exit();
}

$settings_result = $conn->query("SELECT setting_name, setting_value FROM site_settings");
$site_settings = [];
if ($settings_result) {
    while ($row = $settings_result->fetch_assoc()) {
        $site_settings[$row['setting_name']] = $row['setting_value'];
    }
}
