<?php
// This is the new all-in-one header and logic file for the admin panel.

// 1. Start Session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 2. Security Check
if (!isset($_SESSION['admin_id']) || !isset($_SESSION['admin_role']) || $_SESSION['admin_role'] !== 'admin') {
    header('Location: login.php');
    exit();
}
$admin_id = $_SESSION['admin_id'];

// 3. Include Core Files
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/helpers.php';

// 4. Fetch Global Data
$stmt_admin = $conn->prepare("SELECT * FROM admins WHERE id = ?");
$stmt_admin->bind_param("i", $admin_id);
$stmt_admin->execute();
$admin_user = $stmt_admin->get_result()->fetch_assoc();
$stmt_admin->close();

if (!$admin_user) {
    session_destroy();
    header('Location: login.php');
    exit();
}

$settings_result = $conn->query("SELECT * FROM site_settings");
$site_settings = [];
if ($settings_result) {
    while ($row = $settings_result->fetch_assoc()) {
        $site_settings[$row['setting_name']] = $row['setting_value'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) : 'Admin Panel'; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .dropdown-menu-wide { width: 300px; }
        .brand-logo-dark { display: none; }
        [data-bs-theme="dark"] .brand-logo-light { display: none; }
        [data-bs-theme="dark"] .brand-logo-dark { display: inline-block; }
        .border-start-primary { border-left: 0.25rem solid var(--bs-primary) !important; }
        .border-start-success { border-left: 0.25rem solid var(--bs-success) !important; }
        .border-start-info { border-left: 0.25rem solid var(--bs-info) !important; }
        .border-start-warning { border-left: 0.25rem solid var(--bs-warning) !important; }
        .text-xs { font-size: .7rem; }
    </style>
</head>
<body>
<script>
    (() => {
        'use strict';
        const getStoredTheme = () => localStorage.getItem('theme');
        const setStoredTheme = theme => localStorage.setItem('theme', theme);
        const getPreferredTheme = () => {
            const storedTheme = getStoredTheme();
            if (storedTheme) return storedTheme;
            return window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
        };
        const setTheme = theme => { document.documentElement.setAttribute('data-bs-theme', theme); };
        setTheme(getPreferredTheme());
    })();
</script>
<nav class="navbar sticky-top shadow-sm border-bottom">
    <div class="container-fluid">
        <a class="navbar-brand d-flex align-items-center" href="dashboard.php">
            <img src="../<?php echo htmlspecialchars($site_settings['site_logo_url'] ?? ''); ?>" class="brand-logo-light" alt="Site Logo" style="max-height: 35px;">
            <img src="../<?php echo htmlspecialchars($site_settings['site_logo_dark_url'] ?? ''); ?>" class="brand-logo-dark" alt="Site Logo" style="max-height: 35px;">
        </a>
        <div class="d-flex align-items-center ms-auto">
            <button class="btn btn-link nav-link me-2" id="theme-toggler" type="button"><i class="bi bi-sun-fill theme-icon-sun d-none"></i><i class="bi bi-moon-stars-fill theme-icon-moon d-none"></i></button>
            <div class="dropdown">
                <a href="#" class="d-flex align-items-center text-decoration-none dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="bi bi-person-circle fs-2 me-2"></i>
                    <strong class="d-none d-sm-inline"><?php echo htmlspecialchars(strtok($admin_user['full_name'], ' ')); ?></strong>
                </a>
                <ul class="dropdown-menu dropdown-menu-end text-small shadow dropdown-menu-wide p-2">
                    <li><a class="dropdown-item rounded" href="dashboard.php"><i class="bi bi-grid-1x2-fill me-2"></i> Dashboard</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><h6 class="dropdown-header">Bookings & Inquiries</h6></li>
                    <li><a class="dropdown-item rounded" href="manage-messages.php">Contact Messages</a></li>
                    <li><a class="dropdown-item rounded" href="flight-bookings.php">Flight Bookings</a></li>
                    <li><a class="dropdown-item rounded" href="ferry-bookings.php">Ferry Bookings</a></li>
                    <li><a class="dropdown-item rounded" href="hotel-bookings.php">Hotel Bookings</a></li>
                    <li><a class="dropdown-item rounded" href="tour-bookings.php">Tour Bookings</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><h6 class="dropdown-header">Users & Financials</h6></li>
                    <li><a class="dropdown-item rounded" href="manage-users.php">Manage Users</a></li>
                    <li><a class="dropdown-item rounded" href="manage-withdrawals.php">Withdrawal Requests</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><h6 class="dropdown-header">Manage Content</h6></li>
                    <li><a class="dropdown-item rounded" href="manage-tours.php">Tours</a></li>
                    <li><a class="dropdown-item rounded" href="manage-services.php">Services</a></li>
                    <li><a class="dropdown-item rounded" href="manage-hotels.php">Hotels</a></li>
                    <li><a class="dropdown-item rounded" href="manage-articles.php">Articles</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><h6 class="dropdown-header">Settings</h6></li>
                    <li><a class="dropdown-item rounded" href="site-settings.php">Site Settings</a></li>
                    <li><a class="dropdown-item rounded" href="manage-admins.php">Manage Admins</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item rounded" href="edit-profile.php"><i class="bi bi-person-fill-gear me-2"></i>Edit Profile</a></li>
                    <li><a class="dropdown-item rounded text-danger" href="logout.php"><i class="bi bi-box-arrow-right me-2"></i>Log Out</a></li>
                </ul>
            </div>
        </div>
    </div>
</nav>
<main class="container-fluid py-4">
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const getStoredTheme = () => localStorage.getItem('theme');
        const themeToggler = document.getElementById('theme-toggler');
        const sunIcon = document.querySelector('.theme-icon-sun');
        const moonIcon = document.querySelector('.theme-icon-moon');
        const updateIcon = (theme) => {
            if (theme === 'dark') {
                sunIcon.classList.remove('d-none'); moonIcon.classList.add('d-none');
            } else {
                sunIcon.classList.add('d-none'); moonIcon.classList.remove('d-none');
            }
        };
        themeToggler.addEventListener('click', () => {
            const currentTheme = getStoredTheme() || (window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light');
            const newTheme = currentTheme === 'light' ? 'dark' : 'light';
            localStorage.setItem('theme', newTheme);
            document.documentElement.setAttribute('data-bs-theme', newTheme);
            updateIcon(newTheme);
        });
        updateIcon(getStoredTheme() || (window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light'));
    });
</script>
