<?php
session_start();
require_once '../../includes/db.php';

// Security check: ensure an admin is logged in
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

// Get user ID and action from URL
$user_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$action = $_GET['action'] ?? '';

if ($user_id && ($action == 'approve' || $action == 'reject')) {

    $new_status = ($action == 'approve') ? 'verified' : 'rejected';

    // Prepare and execute the update
    $stmt = $conn->prepare("UPDATE users SET verification_status = ? WHERE id = ? AND role LIKE '%_partner'");
    $stmt->bind_param("si", $new_status, $user_id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            $_SESSION['success_message'] = "User #$user_id has been " . $new_status . ".";
            // You could also trigger a notification email to the user here
        } else {
            $_SESSION['error_message'] = "Could not find a pending partner with that ID.";
        }
    } else {
        $_SESSION['error_message'] = "Database error: Could not update user status.";
    }
    $stmt->close();
} else {
    $_SESSION['error_message'] = "Invalid action or user ID.";
}

// Redirect back to the manage users page
header("Location: ../manage-users.php");
exit();

