<?php
session_start();
require_once '../../includes/db.php';

// Security check
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: ../login.php");
    exit;
}

$message_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if ($message_id) {
    $stmt = $conn->prepare("DELETE FROM contact_messages WHERE id = ?");
    $stmt->bind_param("i", $message_id);
    if ($stmt->execute()) {
        $_SESSION['success_message'] = "Message #$message_id has been deleted.";
    } else {
        $_SESSION['error_message'] = "Failed to delete the message.";
    }
    $stmt->close();
} else {
    $_SESSION['error_message'] = "Invalid message ID.";
}

header("Location: ../manage-messages.php");
exit();
?>
